---
generated_at: 2026-01-23 22:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：101-商品管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **価格フィールドの仕様**：sPriceA/sPriceBがコードに存在するが画面に表示されていない
  2. **テーブル定義の完全性**：tblQShopProductの正確なスキーマ定義書が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shopProduct.asp` 4-25行目
- E-02: `asp/includes/shopProduct.asp` 1-144行目
- E-03: `asp/includes/shopMake.asp` 77-101行目
- E-04: `asp/bs_shoppingcartmenu.asp` 1-3行目
- E-05: `asp/bs_shoppingcart.asp` 30-44行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 138行目
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` 102行目
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` 169-189行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品管理画面はbs_shopProduct.aspで実装されている | E-01, E-07 | ○ |
| C-02 | セカンドアドミンのbShoppingCart権限でアクセス制御 | E-01（4行目）logon.hasaccess secondAdmin.bShoppingCart | ○ |
| C-03 | 商品名は必須項目で最大250文字 | E-01（25行目）size=40 maxlength=250、E-02（37-40行目）check() | ○ |
| C-04 | メーカー選択はドロップダウンで実装 | E-01（25行目）select name="iMakeID"、E-03 showMake() | ○ |
| C-05 | 詳細説明はFCKEditorで編集 | E-01（25行目）createFCKInstance | ○ |
| C-06 | 在庫数は数値チェックが行われる | E-02（42-48行目）isNumeriek(iStock) | ○ |
| C-07 | 保存成功時にbs_shoppingcart.aspへリダイレクト | E-01（20行目）response.redirect ("bs_shoppingcart.asp") | ○ |
| C-08 | 削除時に確認ダイアログを表示 | E-01（25行目）confirm('areyousure') | ○ |
| C-09 | tblQShopProductテーブルに保存される | E-02（60-81行目）rs.Open "select * from tblQShopProduct | ○ |
| C-10 | 商品IDは暗号化されて渡される | E-01（6, 25行目）decrypt(request("iShopProductID"))、encrypt(shopProduct.iID) | ○ |
| C-11 | CSRFトークンで保護されている | E-01（25行目）QS_secCodeHidden | ○ |
| C-12 | 商品削除時に画像フォルダも削除される | E-02（83-90行目）fso.deleteFolder | ○ |
| C-13 | メーカー一覧はtblQShopMakeテーブルから取得 | E-03（79行目）select iId,sName from tblQShopMake | ○ |
| C-14 | ショッピングカート管理画面から遷移してくる | E-05、E-08 | ○ |
| C-15 | iCustomerIDでマルチテナント分離されている | E-02（74,76行目）rs("iCustomerID") = cId | ○ |
| C-16 | 作成日時・更新日時が自動設定される | E-02（62,75行目）dCreatedTS=now()、dUpdatedTS=now() | ○ |
| C-17 | 価格フィールド（sPriceA/sPriceB）が存在する | E-02（3,23-24,69-70行目）sPriceA, sPriceB | △ |
| C-18 | sDefaultImageフィールドが存在する | E-02（30,77行目）sDefaultImage | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17/C-18について**：sPriceA、sPriceB、sDefaultImageはクラス定義に存在するが、bs_shopProduct.asp画面上では入力項目として表示されていない。これらのフィールドは将来的な拡張用、または他の画面（価格管理画面や画像管理画面）で使用される可能性がある。
  - 候補：価格設定機能の設計書 / bs_shopProductImg.aspでのデフォルト画像設定 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：基本的なCRUD操作の実装は明確にコードで確認可能
- **リスク1（中）**：価格関連フィールドの用途が不明確（将来の機能拡張に影響の可能性）
- **リスク0（低）**：セキュリティ対策（CSRF、権限チェック）は適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 商品名の必須チェックが正しく動作するか確認
- [ ] 在庫数に非数値を入力した場合のエラーハンドリングを確認
- [ ] 削除時に関連する画像フォルダが正しく削除されるか確認
- [ ] sPriceA/sPriceBフィールドの用途と今後の拡張計画を確認
- [ ] マルチテナント環境で他顧客の商品が見えないことを確認
