---
generated_at: 2026-01-23 22:28:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-商品カテゴリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shopProductCat.asp` 1-34行目
- E-02: `asp/includes/shopProduct.asp` 117-143行目（categories、saveCatsメソッド）
- E-03: `asp/includes/shopCategory.asp` 11-36行目（subcategories、listメソッド）
- E-04: `asp/bs_shoppingcart.asp` 40行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 139行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 103行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品カテゴリ画面はbs_shopProductCat.aspで実装 | E-01, E-06 | ○ |
| C-02 | セカンドアドミンのbShoppingCart権限でアクセス制御 | E-01（4行目）logon.hasaccess secondAdmin.bShoppingCart | ○ |
| C-03 | ショッピングカート管理画面からCategoriesボタンで遷移 | E-04 href="bs_shopProductCat.asp?iShopProductID=" | ○ |
| C-04 | 商品名を読取専用で表示 | E-01（15行目）sanitize(shopProduct.sName) | ○ |
| C-05 | カテゴリは階層構造（親・サブ）で表示 | E-01（15-32行目）ネストしたfor each | ○ |
| C-06 | 現在の割当状態はチェック済みで表示 | E-01（17-18行目）categories.exists(convertGetal(cat)) | ○ |
| C-07 | カテゴリIDは暗号化されている | E-01（20行目）encrypt(cat)、E-02（139行目）decrypt(trim(arrC(i))) | ○ |
| C-08 | saveCatsで既存割当を全削除後に新規登録 | E-02（135-142行目）DELETE then INSERT | ○ |
| C-09 | tblQShopProdCatテーブルを使用 | E-02（120, 135, 140行目）tblQShopProdCat | ○ |
| C-10 | categoriesメソッドで現在の割当を取得 | E-02（117-127行目）SELECT iCategoryID FROM tblQShopProdCat | ○ |
| C-11 | listメソッドで親カテゴリ一覧を取得 | E-03（24-36行目）WHERE iParentCatID is null | ○ |
| C-12 | subcategoriesメソッドでサブカテゴリを取得 | E-03（11-23行目）WHERE iParentCatID={親ID} | ○ |
| C-13 | 保存成功時にfb_saveOKメッセージ | E-01（12行目）message.Add("fb_saveOK") | ○ |
| C-14 | CSRFトークンで保護されている | E-01（15行目）QS_secCodeHidden | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面の機能はシンプルであり、すべての主張に対してコードによる根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：基本的な多対多リレーション管理の標準的な実装
- **リスク0（低）**：セキュリティ対策（CSRF、権限チェック）は適切
- **リスク0（低）**：エラーハンドリングは保存処理のみで十分

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ未選択時に全割当が解除されることを確認
- [ ] 大量のカテゴリがある場合の表示・パフォーマンスを確認
- [ ] 親カテゴリとサブカテゴリの両方を選択した場合の動作確認
- [ ] マルチテナント環境で他顧客のカテゴリが表示されないことを確認
