---
generated_at: 2026-01-23 22:32:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-商品画像

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_shopProductImg.asp` 1-16行目
- E-02: `asp/bs_shopProductImgUpload.asp` 1-41行目
- E-03: `asp/includes/shopProduct.asp` 91-116, 128-133行目（deleteImage、images、setAsDefaultImageメソッド）
- E-04: `asp/bs_shoppingcart.asp` 41行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 140-141行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 104-105行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 商品画像画面はbs_shopProductImg.aspで実装 | E-01, E-06 | ○ |
| C-02 | セカンドアドミンのbShoppingCart権限でアクセス制御 | E-01（4行目）logon.hasaccess secondAdmin.bShoppingCart | ○ |
| C-03 | ショッピングカート管理画面からImagesボタンで遷移 | E-04 href="bs_shopProductImg.asp?iShopProductID=" | ○ |
| C-04 | サムネイルは150px幅で表示 | E-01（15行目）maxsize=150 | ○ |
| C-05 | 拡大表示は600px幅 | E-01（15行目）maxsize=600 | ○ |
| C-06 | デフォルト画像は「default image」とイタリック表示 | E-01（15行目）<i>default image</i> | ○ |
| C-07 | deleteクエリストリングで画像削除 | E-01（8-10行目）request.querystring("delete")、shopProduct.deleteImage | ○ |
| C-08 | defaultクエリストリングでデフォルト設定 | E-01（11-13行目）request.querystring("default")、shopProduct.setAsDefaultImage | ○ |
| C-09 | 削除時に確認ダイアログ表示 | E-01（15行目）confirm('areyousure') | ○ |
| C-10 | imagesメソッドでファイルシステムから画像一覧取得 | E-03（103-116行目）fso.getFolder、folder.files | ○ |
| C-11 | deleteImageメソッドでファイル物理削除 | E-03（91-102行目）fso.deletefile | ○ |
| C-12 | デフォルト画像削除時にsDefaultImageを空に | E-03（98-101行目）sDefaultImage="" then save() | ○ |
| C-13 | アップロードはbs_shopProductImgUpload.aspで処理 | E-01（15行目）action="bs_shopProductImgUpload.asp"、E-02 | ○ |
| C-14 | JPGファイルのみ許可 | E-01（15行目）only jpg files、E-02（26行目）lcase(GetFileExtension)<>"jpg" | ○ |
| C-15 | 画像は{userfiles}/qsscart/{商品ID}/に保存 | E-02（9-14, 17行目）C_VIRT_DIR & Application("QS_CMS_userfiles") & qsscart & "/" & shopProduct.iId | ○ |
| C-16 | CSRFトークンで保護されている | E-01（15行目）QS_secCodeHidden、E-02（21行目）checkCSRF_Upload | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面の機能はすべてコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：基本的なファイル操作の標準的な実装
- **リスク1（中）**：大量の画像ファイルがある場合のパフォーマンス（FileSystemObjectでの一覧取得）
- **リスク0（低）**：セキュリティ対策（CSRF、権限チェック、拡張子チェック）は適切

## 6) レビュアーチェックリスト（最小）
- [ ] JPG以外のファイルがアップロードできないことを確認
- [ ] 大容量ファイルアップロード時の動作確認
- [ ] デフォルト画像を削除した場合の表示確認
- [ ] 画像フォルダが存在しない場合の動作確認
- [ ] ファイル名に特殊文字が含まれる場合の動作確認
