---
generated_at: 2026-01-23 22:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-カレンダー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_ac.asp` 1-10行目
- E-02: `asp/bs_ac_mycals.asp` 1-25行目
- E-03: `asp/bs_ac_calendar.asp` 1-16行目
- E-04: `asp/bs_ac_bookings.asp` 1-8行目
- E-05: `asp/bs_ac_booking.asp` 1-27行目
- E-06: `asp/bs_ac_embed.asp` 1-39行目
- E-07: `asp/includes/ac_calendar.asp` 1-3行目（cls_Calendar）
- E-08: `asp/includes/ac_calendarbooking.asp` 1-136行目（cls_calendarbooking）
- E-09: `asp/includes/ac_statuslist.asp` 1-36行目（cls_statusList）
- E-10: `asp/includes/ac_calendarview.asp` 1-155行目（calendarview）
- E-11: `asp/bs_ac_menu.asp` 1-4行目
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 142行目
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 106行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カレンダー管理画面はbs_ac.aspで実装 | E-01, E-13 | ○ |
| C-02 | セカンドアドミンのbAvailabilityCal権限でアクセス制御 | E-01（4行目）logon.hasaccess secondAdmin.bAvailabilityCal | ○ |
| C-03 | calActionパラメータで画面分岐 | E-01（8行目）select case lcase(action) | ○ |
| C-04 | createCal/editCalでbs_ac_calendar.aspをインクルード | E-01（9行目）case "createcal","editcal" → include bs_ac_calendar.asp | ○ |
| C-05 | embedCodeでbs_ac_embed.aspをインクルード | E-01（9行目）case "embedcode" → include bs_ac_embed.asp | ○ |
| C-06 | bookingでbs_ac_booking.aspをインクルード | E-01（9行目）case "booking" → include bs_ac_booking.asp | ○ |
| C-07 | bookingsでbs_ac_bookings.aspをインクルード | E-01（9行目）case "bookings" → include bs_ac_bookings.asp | ○ |
| C-08 | デフォルトでbs_ac_mycals.aspをインクルード | E-01（9行目）case else → include bs_ac_mycals.asp | ○ |
| C-09 | cls_Calendarクラスでカレンダー管理 | E-07 Class cls_Calendar | ○ |
| C-10 | cls_calendarbookingクラスで予約管理 | E-08 class cls_calendarbooking | ○ |
| C-11 | cls_statusListクラスでステータス管理 | E-09 Class cls_statusList | ○ |
| C-12 | calendarviewクラスでカレンダー表示 | E-10 class calendarview | ○ |
| C-13 | 予約の重複チェックはcls_calendarbookingのcheck関数 | E-08（43-96行目）check()内の重複チェックロジック | ○ |
| C-14 | tblCalendarテーブルを使用 | E-07 select * from tblCalendar | ○ |
| C-15 | tblCalendarBookingテーブルを使用 | E-08（22行目）select * from tblCalendarBooking | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。本画面の機能はすべてコードで確認できた。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：ルーティングロジックは明確で分かりやすい
- **リスク0（低）**：各サブ画面は独立したファイルで管理されており保守性が高い
- **リスク0（低）**：セキュリティ対策（権限チェック）は適切

## 6) レビュアーチェックリスト（最小）
- [ ] 無効なcalAction値を指定した場合の動作確認
- [ ] iCalIDなしで各サブ画面にアクセスした場合の動作確認
- [ ] 権限なしユーザーのアクセス拒否を確認
- [ ] 各サブ画面間の遷移が正しく動作することを確認
