---
generated_at: 2026-01-23 22:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-予約一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_bookings.asp` 1-8行目
- E-02: `asp/includes/ac_calendar.asp` bookings関数
- E-03: `asp/includes/ac_calendarbooking.asp` cls_calendarbookingクラス
- E-04: `asp/includes/ac_statuslist.asp` getImage/showSelected関数
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 143行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 107行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 予約一覧画面はbs_ac_bookings.aspで実装 | E-01, E-06 | ○ |
| C-02 | calAction=bookingsでアクセス | bs_ac.asp（9行目）case "bookings" | ○ |
| C-03 | カレンダー選択ドロップダウンで切り替え | E-01（6行目）select onchange="javascript:document.bookingForm.submit()" | ○ |
| C-04 | 予約一覧は開始日降順 | E-02 ORDER BY dStartdate desc | ○ |
| C-05 | sorttable.jsでソート機能提供 | E-01（6行目）class="sortable"、script src="sorttable.js" | ○ |
| C-06 | ステータスアイコンを表示 | E-01（6行目）statuslist.getImage(bookings(booking).iStatus) | ○ |
| C-07 | 日付はヨーロッパ形式 | E-01（6行目）convertEuroDate(bookings(booking).dStartDate) | ○ |
| C-08 | Email欄はmailtoリンク | E-01（6行目）<a href="mailto:..."> | ○ |
| C-09 | メールなしは「---」表示 | E-01（6行目）if not isLeeg then...else---end if | ○ |
| C-10 | Notesはポップアップリンク | E-01（6行目）rel="example1" href="...seeNotes=1" | ○ |
| C-11 | Modifyリンクで編集画面へ | E-01（6行目）href="bs_ac.asp?iBookingID=...&calAction=booking" | ○ |
| C-12 | Add Reservationリンク | E-01（6行目）<a href="bs_ac.asp?iCalID=...&calAction=booking"> | ○ |
| C-13 | カレンダープレビュー表示 | E-01（6行目）script src="bs_ac_view.asp?...mode=js" | ○ |
| C-14 | 12ヶ月分のプレビュー | E-01（6行目）months=12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：標準的な一覧表示機能
- **リスク0（低）**：sorttable.jsは実績のあるライブラリ

## 6) レビュアーチェックリスト（最小）
- [ ] 大量の予約がある場合のパフォーマンス確認
- [ ] ソート機能が正しく動作することを確認
- [ ] Notesポップアップが正しく表示されることを確認
