---
generated_at: 2026-01-23 22:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-予約編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_booking.asp` 1-27行目
- E-02: `asp/includes/ac_calendarbooking.asp` 1-136行目
- E-03: `asp/includes/ac_statuslist.asp` 18-34行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 144行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 108行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 予約編集画面はbs_ac_booking.aspで実装 | E-01, E-05 | ○ |
| C-02 | calAction=bookingでアクセス | bs_ac.asp（9行目）case "booking" | ○ |
| C-03 | seeNotes=1でメモポップアップ | E-01（7-11行目）if request.querystring("seeNotes")<>"" | ○ |
| C-04 | getRequestValues()でフォーム値取得 | E-01（15行目）booking.getRequestValues()、E-02（7-18行目） | ○ |
| C-05 | 保存後に予約一覧へリダイレクト | E-01（17行目）response.redirect("bs_ac.asp?...&calAction=bookings") | ○ |
| C-06 | 削除時に確認ダイアログ | E-01（26行目）confirm('Are you sure to delete this reservation?') | ○ |
| C-07 | 名前・開始日・終了日は必須 | E-02（45-56行目）if isLeeg(sName/dStartDate/dEndDate) | ○ |
| C-08 | 終了日<開始日でエラー | E-02（57-59行目）if dEndDate<dStartDate then customErrorMessage | ○ |
| C-09 | 重複チェックを実装 | E-02（61-95行目）Double bookings are not allowed! | ○ |
| C-10 | 半日予約を考慮した重複チェック | E-02（79-89行目）bSOnlyAfternoon/bEOnlyMorning判定 | ○ |
| C-11 | ステータス3種類（Confirmed/Pending/Unavailable） | E-03（6-8行目）list.Add 20,"Confirmed"/17,"Pending"/15,"Unavailable" | ○ |
| C-12 | jQuery DatePicker使用 | E-01（26行目）JQDatePickerFT("dStartDate","dEndDate") | ○ |
| C-13 | FCKEditorでメモ編集 | E-01（26行目）createFCKInstance booking.sNotes,"siteBuilderMailSource","sNotes" | ○ |
| C-14 | 12ヶ月分のカレンダープレビュー | E-01（26行目）months=12 | ○ |
| C-15 | tblCalendarBookingに保存 | E-02（103-130行目）rs.Open "select * from tblCalendarBooking | ○ |
| C-16 | 削除はDELETE文で実行 | E-02（131-134行目）delete from tblCalendarBooking where iId | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：重複チェックロジックは詳細にコードで確認可能
- **リスク0（低）**：半日予約の考慮も適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 重複チェックが正しく動作することを確認（特に半日予約のケース）
- [ ] 日付ピッカーの表示形式が正しいことを確認
- [ ] メモのリッチテキスト編集が正しく保存されることを確認
