---
generated_at: 2026-01-23 22:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-カレンダー表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_calendar.asp` 1-16行目
- E-02: `asp/includes/ac_calendar.asp` cls_Calendarクラス全体
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 145行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 109行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カレンダー編集画面はbs_ac_calendar.aspで実装 | E-01, E-04 | ○ |
| C-02 | calAction=createCal/editCalでアクセス | bs_ac.asp（9行目）case "createcal","editcal" | ○ |
| C-03 | カレンダー名は必須項目 | E-02 check()関数 if isLeeg(sName) then message.addError | ○ |
| C-04 | 保存後にマイカレンダー一覧へリダイレクト | E-01（9行目）response.redirect("bs_ac.asp") | ○ |
| C-05 | 削除時にNO WAY TO UNDO警告 | E-01（15行目）confirm('...NO WAY TO UNDO!') | ○ |
| C-06 | 削除時に関連予約も削除 | E-02 delete関数 delete from tblCalendarBooking | ○ |
| C-07 | tblCalendarに保存 | E-02 rs.Open "select * from tblCalendar | ○ |
| C-08 | iCustomerIDでマルチテナント分離 | E-02 rs("iCustomerID") = cId | ○ |
| C-09 | dCreatedTS自動設定 | E-02 rs("dCreatedTS")=now() | ○ |
| C-10 | 最大50文字 | E-01（15行目）maxlength="50" | ○ |
| C-11 | 補足説明が表示される | E-01（15行目）(in most cases the name of the property) | ○ |
| C-12 | 既存編集時のみ削除ボタン表示 | E-01（15行目）if convertGetal(calendar.iId)<>0 then | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：カレンダー削除時の関連予約一括削除は復元不可
- **リスク0（低）**：シンプルなCRUD操作で問題なし

## 6) レビュアーチェックリスト（最小）
- [ ] カレンダー削除時に関連予約も正しく削除されることを確認
- [ ] 同名カレンダーの登録が可能かどうか確認
- [ ] マルチテナント環境で他顧客のカレンダーが見えないことを確認
