---
generated_at: 2026-01-23 22:52:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-カレンダービュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_view.asp` 1-165行目
- E-02: `asp/includes/ac_calendarview.asp` 1-155行目
- E-03: `asp/includes/ac_statuslist.asp` 10-17行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 146行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 110行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カレンダービュー画面はbs_ac_view.aspで実装 | E-01, E-05 | ○ |
| C-02 | 認証不要（secure=false） | E-01（12行目）cal.secure=false | ○ |
| C-03 | 存在しないカレンダーで「Calendar not available」 | E-01（15-17行目）if convertGetal(cal.iId)=0 then | ○ |
| C-04 | デフォルト12ヶ月表示 | E-01（28行目）else mm=12 | ○ |
| C-05 | 最大36ヶ月制限 | E-01（30-32行目）if convertGetal(mm)>36 then mm=36 | ○ |
| C-06 | timeパラメータで期間モード切り替え | E-01（33行目）select case request.querystring("time") | ○ |
| C-07 | ajax=prev/nextでナビゲーション | E-01（37-42, 54-59, 71-76行目）select case request.form("ajax") | ○ |
| C-08 | セッション変数でナビゲーション位置保持 | E-01（39-45行目）session(cal.iId&"c0") | ○ |
| C-09 | viewMonth関数でカレンダー生成 | E-01（48行目）cv.viewMonth(month(sdate),year(sdate)) | ○ |
| C-10 | 凡例表示（legend=trueで表示） | E-01（98-111行目）if request.querystring("legend")<>"false" | ○ |
| C-11 | ステータス背景画像4種類 | E-01（104-107行目）10.gif/15.gif/17.gif/20.gif | ○ |
| C-12 | mode=jsでdocument.write出力 | E-01（138-140行目）document.write ('...')| ○ |
| C-13 | mode=if/htmlで完全HTML出力 | E-01（119-136行目）<!DOCTYPE html...| ○ |
| C-14 | ajax.txtからJavaScript読み込み | E-01（150行目）fso.opentextfile(server.mappath("ajax.txt")) | ○ |
| C-15 | 多言語対応（曜日・月名） | E-01（6行目）daysArr=split(l("days"),"/")、E-02（126行目）l("months") | ○ |
| C-16 | 処理時間をコメント出力 | E-01（116行目）PrintTimer(startTimer) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：公開画面として適切に設計されている
- **リスク0（低）**：セッション変数使用は妥当な設計

## 6) レビュアーチェックリスト（最小）
- [ ] 存在しないカレンダーIDでアクセスした場合のエラー表示確認
- [ ] 36ヶ月を超える月数を指定した場合の動作確認
- [ ] Ajax前月/次月ナビゲーションの動作確認
- [ ] 各出力モード（js/if/html）の動作確認
