---
generated_at: 2026-01-23 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-リストテンプレート編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リストテンプレート数が3種類である点**：画像ファイルの実在確認が必要
  2. **updatedTSカラムの自動更新**：page.aspのsave処理詳細確認が必要
  3. **テンプレートプレビュー画像パス**：実ファイル存在確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editListTemplate.asp` - メイン画面ソースコード
- E-02: `asp/includes/page.asp` - cls_pageクラス定義
- E-03: `asp/bs_security.asp` - セキュリティ処理（インクルード参照）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.11はリストテンプレート編集画面である | E-04 | ○ |
| C-02 | URLパスはasp/bs_editListTemplate.aspである | E-01, E-04 | ○ |
| C-03 | 3種類のテンプレートから選択可能 | E-01 (行27-35) | ○ |
| C-04 | ラジオボタンで選択する | E-01 (行28,31,34) | ○ |
| C-05 | sLPTemplateに値1/2/3が設定される | E-01 (行28,31,34) | ○ |
| C-06 | page.save()でデータベースに保存 | E-01 (行14) | ○ |
| C-07 | 保存後bs_listPage.aspにリダイレクト | E-01 (行14) | ○ |
| C-08 | QS_secCodeHiddenでCSRF対策を実施 | E-01 (行21) | ○ |
| C-09 | encrypt/decrypt関数でIDを暗号化 | E-01 (行10,22) | ○ |
| C-10 | 関連機能はリストページ管理(No.13) | E-05 | ○ |
| C-11 | 補助機能はテンプレート作成・編集(No.26) | E-05 | ○ |
| C-12 | プレビュー画像はfixedImages/liststyles/配下 | E-01 (行27,30,33) | ○ |
| C-13 | 画像幅は200pxでbox-shadow適用 | E-01 (行27,30,33) | ○ |
| C-14 | 戻るリンクでbs_listPage.aspに遷移 | E-01 (行18,45) | ○ |
| C-15 | bs_security.aspで認証チェック | E-01 (行2) | ○ |
| C-16 | cls_pageクラスでページデータを管理 | E-02 | ○ |
| C-17 | tblPageテーブルにデータ格納 | E-02 (行252,468) | ○ |
| C-18 | updatedTSが自動更新される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- updatedTSの自動更新については、page.aspのsave関数内で更新されているかの詳細確認が必要
  - 候補：page.asp save関数の詳細部分 / データベーストリガー / アプリケーション設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造と機能は明確にソースコードから確認可能
- 1: 中リスク - プレビュー画像ファイルの実在確認が推奨される
- 0: 低リスク - CSRF対策は実装されていることを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] fixedImages/liststyles/配下にls1.jpg, ls2.jpg, ls3.jpgが存在するか
- [ ] tblPageテーブルにsLPTemplateカラムが存在するか
- [ ] リストページ編集画面からのリンクが正しく設定されているか
- [ ] セカンド管理者の権限でこの画面にアクセス可能か確認
