---
generated_at: 2026-01-23 22:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-マイカレンダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にコードによる根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_ac_mycals.asp` 1-24行目
- E-02: `asp/includes/ac_calendar.asp` mycals関数 全体
- E-03: `asp/bs_ac.asp` 1-20行目（ルーター処理）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 147行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 111行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マイカレンダー画面はbs_ac_mycals.aspで実装 | E-01, E-05 | ○ |
| C-02 | calActionパラメータなしでアクセス | E-03（9行目）case else: include bs_ac_mycals.asp | ○ |
| C-03 | mycals関数でカレンダー一覧取得 | E-01（2-3行目）set cals=calObj.mycals(cId) | ○ |
| C-04 | Dictionaryオブジェクトで返却 | E-02 set mycals=Server.CreateObject("Scripting.Dictionary") | ○ |
| C-05 | カレンダー0件で「No calendars yet.」表示 | E-01（17-22行目）if cals.count=0 then...No calendars yet | ○ |
| C-06 | カレンダー名順で表示 | E-02 ORDER BY sName | ○ |
| C-07 | ulタグでリスト表示 | E-01（4行目）response.write "<ul>" | ○ |
| C-08 | Modify / Deleteリンクあり | E-01（10行目）Modify / Delete | ○ |
| C-09 | Reservationsリンクあり | E-01（11行目）Reservations | ○ |
| C-10 | Preview Calendarリンクあり | E-01（13行目）Preview Calendar | ○ |
| C-11 | プレビューは別タブ（_blank） | E-01（13行目）target="_blank" | ○ |
| C-12 | iCustomerIDでフィルタリング | E-02 WHERE iCustomerID=cId | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：読み取り専用画面でデータ更新なし
- **リスク0（低）**：マルチテナント分離が適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] カレンダー0件時のメッセージ表示確認
- [ ] 他顧客のカレンダーが表示されないことを確認
- [ ] 各操作リンクの遷移先が正しいことを確認
- [ ] プレビューリンクが別タブで開くことを確認
