---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：111-埋め込みコード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **業務上の目的・背景**：具体的なユースケース（宿泊施設等）は推測に基づく
  2. **AJAX処理の詳細**：ajax.txtの内容未確認
  3. **権限設定の詳細**：secondAdmin.bAvailabilityCalの完全な制御フロー

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_ac_embed.asp` - 埋め込みコード生成の主要ロジック
- E-02: `asp/bs_ac.asp` - カレンダー管理ルーター（Line 8-9）
- E-03: `asp/bs_ac_view.asp` - カレンダービュー生成（Line 29-144）
- E-04: `asp/includes/ac_calendar.asp` - cls_Calendarクラス定義
- E-05: `asp/bs_security.asp` - セキュリティ処理
- E-06: `asp/includes/secondAdmin.asp` - セカンド管理者権限定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 148-149）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 112）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_ac_embed.aspで実装されている | E-01, E-02 | ○ |
| C-02 | 3種類の埋め込みコード（JS/iframe/HTML）を生成 | E-01 (Line 31-32) | ○ |
| C-03 | 表示期間は0:次のX月、1:今年、2:来年から選択 | E-01 (Line 33-34), E-03 (Line 33-85) | ○ |
| C-04 | 表示月数はデフォルト12ヶ月、最大36ヶ月 | E-01 (Line 17-18), E-03 (Line 30-31) | ○ |
| C-05 | 凡例の表示/非表示が設定可能 | E-01 (Line 4-13) | ○ |
| C-06 | URLパラメータにcalAction=embedcodeが必要 | E-02 (Line 8-9) | ○ |
| C-07 | セカンド管理者はbAvailabilityCalで制御 | E-05, E-06 (Line 67) | ○ |
| C-08 | カレンダー情報はtblCalendarから取得 | E-04 (cls_Calendar.pick) | ○ |
| C-09 | フォーム変更時にJavaScriptで自動送信 | E-01 (Line 33-34 onchange属性) | ○ |
| C-10 | テキストエリアクリックで全選択される | E-01 (Line 35 onclick="javascript:this.select();") | ○ |
| C-11 | 機能No.76「カレンダー埋め込みコード」に対応 | E-07 | ○ |
| C-12 | bs_ac.aspからインクルードされる | E-02 | ○ |
| C-13 | カレンダー名が画面に表示される | E-01 (Line 33 cal.sName) | ○ |
| C-14 | データベース更新は行われない（参照のみ） | E-01（更新処理なし） | ○ |
| C-15 | 凡例はAvailable/Unavailable/Pending/Bookedの4種類 | E-03 (Line 104-107) | ○ |
| C-16 | AJAXでナビゲーション（prev/next）が可能 | E-03 (Line 93-94) | ○ |
| C-17 | 宿泊施設やレンタルスペースでの使用 | **根拠なし** | △ |
| C-18 | カレンダービューはmode=js/if/htmlで切り替え | E-03 (Line 118-144) | ○ |

## 4) 不足情報（Unknown / Missing）
- 業務上の具体的なユースケース（C-17）は推測に基づく
  - 候補：ユーザーインタビュー / 製品マニュアル / 導入事例

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 技術的な実装は全てコードで確認可能
- 1: 中リスク - 業務用途の記述は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 3種類の埋め込みコード形式が正しく記述されているか
- [ ] 表示期間の選択肢（0/1/2）の説明が正確か
- [ ] 最大月数36の制限がコードと一致しているか
- [ ] セキュリティ要件（bAvailabilityCal）の説明が適切か
- [ ] 関連ファイル一覧に漏れがないか
