---
generated_at: 2026-01-23 22:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：112-カレンダーメニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_ac_menu.asp` - メニュー表示の実装（3行）
- E-02: `asp/bs_ac.asp` - 親画面、メニューのインクルード（Line 4, 8-9）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 149）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 113）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_ac_menu.aspで実装されている | E-01 | ○ |
| C-02 | bs_ac.asp内でインクルードされて表示される | E-02 (Line 4) | ○ |
| C-03 | My Calendarsリンクがある | E-01 (Line 2) | ○ |
| C-04 | Create Calendarリンクがある | E-01 (Line 3) | ○ |
| C-05 | My Calendarsリンク先はbs_ac.asp | E-01 (Line 2) | ○ |
| C-06 | Create Calendarリンク先はbs_ac.asp?calAction=createCal | E-01 (Line 3) | ○ |
| C-07 | getArtLink関数を使用している | E-01 | ○ |
| C-08 | データベースアクセスは発生しない | E-01（DBアクセスコードなし） | ○ |
| C-09 | 入力項目を持たない | E-01（フォーム要素なし） | ○ |
| C-10 | 機能No.74「予約カレンダー」に対応 | E-03 | ○ |
| C-11 | テーブルレイアウトでメニューを配置 | E-01 (Line 2 table要素) | ○ |
| C-12 | ファイルは3行のHTMLコードで構成 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなファイルで、全機能がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] リンク先URLが正しく記述されているか
- [ ] getArtLink関数の引数が適切か
- [ ] 親画面との関係が正しく説明されているか
