---
generated_at: 2026-01-23 22:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：113-セキュリティ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **logon.asp の実装詳細**：推定パスで、実際のファイルを確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_security.asp` - セキュリティチェック処理（79行）
- E-02: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス定義（232行）
- E-03: `asp/includes/customer.asp` - customerオブジェクト
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 150-151）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 114）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_security.aspで実装されている | E-01 | ○ |
| C-02 | 他の画面からインクルードされる | E-01（使用パターン） | ○ |
| C-03 | Session変数で認証状態をチェック | E-01 (Line 7) | ○ |
| C-04 | Cookie認証モードが存在する | E-01 (Line 8-12) | ○ |
| C-05 | 未認証時はnoaccess.htmにリダイレクト | E-01 (Line 11) | ○ |
| C-06 | bs_pageパラメータでリダイレクト可能 | E-01 (Line 14-16) | ○ |
| C-07 | プライマリ管理者時に全権限が付与される | E-01 (Line 17-75) | ○ |
| C-08 | デフォルトパスワード使用時にリダイレクト | E-01 (Line 76-78) | ○ |
| C-09 | customer.clearPageCache()を呼び出す | E-01 (Line 79) | ○ |
| C-10 | 50以上の権限フラグが存在する | E-02 (Line 3-7) | ○ |
| C-11 | tblSecondAdminテーブルを参照 | E-02 (Line 14) | ○ |
| C-12 | SHA256でパスワードをハッシュ化 | E-02 (Line 174-175) | ○ |
| C-13 | 機能No.3「セカンドアドミン管理」に対応 | E-04 | ○ |
| C-14 | customer.secondAdminでアクセス | E-01 (Line 2-3), E-03 | ○ |
| C-15 | logon.currentPWで現在のパスワード取得 | E-01 (Line 17) | ○ |
| C-16 | logon.logon()でCookie認証実行 | E-01 (Line 9) | ○ |
| C-17 | logon.aspに認証ロジックがある | **推定パス** | △ |
| C-18 | QS_enableCookieModeでCookie認証を制御 | E-01 (Line 8) | ○ |
| C-19 | blockDefaultPWでデフォルトPWを制限 | E-01 (Line 76) | ○ |
| C-20 | devVersion()で開発モードを判定 | E-01 (Line 77) | ○ |

## 4) 不足情報（Unknown / Missing）
- logon.aspの実際のファイルパスと実装内容（C-17）
  - 候補：asp/includes/logon.asp / asp/logon.asp / begin.aspに含まれる

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ処理の大部分はコードで確認可能
- 1: 中リスク - logonオブジェクトの詳細実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 認証フローが正しく記述されているか
- [ ] 権限フラグ一覧に漏れがないか
- [ ] リダイレクト先URLが正確か
- [ ] セキュリティ上の考慮点が適切に説明されているか
- [ ] logonオブジェクトの実際の実装を確認
