---
generated_at: 2026-01-23 22:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-セカンド管理者

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_secondAdmin.asp` - 権限設定画面（27行）
- E-02: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス定義（232行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 153）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 116）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_secondAdmin.aspで実装されている | E-01 | ○ |
| C-02 | 50以上の権限フラグが存在する | E-02 (Line 3-7) | ○ |
| C-03 | プライマリ管理者のみがアクセス可能 | E-01 (Line 4) | ○ |
| C-04 | セカンド管理者でログイン時はリダイレクト | E-01 (Line 4) | ○ |
| C-05 | パスワード未設定時はbs_secondAdminPW.aspにリダイレクト | E-01 (Line 7) | ○ |
| C-06 | 保存時にcheckCSRF()を実行 | E-01 (Line 15, 19) | ○ |
| C-07 | 保存時にsecAdmin.save()を呼び出す | E-01 (Line 17) | ○ |
| C-08 | 削除時にsecAdmin.delete()を呼び出す | E-01 (Line 20) | ○ |
| C-09 | 削除後はbs_applyTotalPW.aspにリダイレクト | E-01 (Line 21) | ○ |
| C-10 | 保存成功時にfb_saveOKメッセージを表示 | E-01 (Line 17) | ○ |
| C-11 | tblSecondAdminテーブルを使用 | E-02 (Line 14, 104) | ○ |
| C-12 | iCustomerIDで顧客を識別 | E-02 (Line 14, 161-165) | ○ |
| C-13 | 機能No.3「セカンドアドミン管理」に対応 | E-03 | ○ |
| C-14 | 一部チェックボックスはonclickでフォーム送信 | E-01 (Line 25) | ○ |
| C-15 | bHomeConstantsの変更でVBScriptオプション切り替え | E-01 (Line 25) | ○ |
| C-16 | bFormsの変更でエクスポートオプション切り替え | E-01 (Line 25) | ○ |
| C-17 | bIntranetの変更で関連オプション切り替え | E-01 (Line 25-26) | ○ |
| C-18 | customer.bApplicationでVBScript権限の表示制御 | E-02 (Line 24-28, 114-118) | ○ |
| C-19 | customer.bEnableNewslettersでニュースレター権限の表示制御 | E-01 (Line 26), E-02 (Line 74) | ○ |
| C-20 | customer.bShoppingCartでショッピングカート権限の表示制御 | E-02 (Line 66-70) | ○ |
| C-21 | clearMenuCacheでキャッシュクリア | E-02 (Line 169) | ○ |
| C-22 | QS_secCodeHiddenでCSRFトークン出力 | E-01 (Line 22) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全機能がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 権限フラグの一覧が網羅されているか
- [ ] 保存/削除処理のフローが正確か
- [ ] 条件付き表示項目の説明が適切か
- [ ] リダイレクト先URLが正確か
- [ ] セキュリティ関連処理（CSRF等）の説明が適切か
