---
generated_at: 2026-01-23 22:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：116-セカンド管理者PW

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_secondAdminPW.asp` - パスワード設定画面（13行）
- E-02: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス定義（232行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 154）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 117）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_secondAdminPW.aspで実装されている | E-01 | ○ |
| C-02 | プライマリ管理者のみがアクセス可能 | E-01 (Line 4) | ○ |
| C-03 | セカンド管理者でログイン時はリダイレクト | E-01 (Line 4) | ○ |
| C-04 | 保存時にcheckCSRF()を実行 | E-01 (Line 9) | ○ |
| C-05 | getPasswordValues()でパスワードを取得 | E-01 (Line 10) | ○ |
| C-06 | save()成功時はbs_secondAdmin.aspにリダイレクト | E-01 (Line 11) | ○ |
| C-07 | パスワードはSHA256でハッシュ化 | E-02 (Line 174-175) | ○ |
| C-08 | check()でバリデーション実行 | E-02 (Line 75-94) | ○ |
| C-09 | 必須チェックでerr_mandatoryエラー | E-02 (Line 77-79) | ○ |
| C-10 | 不一致でpwnomatchエラー | E-02 (Line 80-82) | ○ |
| C-11 | プライマリPW重複でerr_firstandsecondpasswordエラー | E-02 (Line 83-85) | ○ |
| C-12 | デフォルトPW重複でerr_backsitepwエラー | E-02 (Line 86-88) | ○ |
| C-13 | 入力フィールドはtype="password" | E-01 (Line 12) | ○ |
| C-14 | 最大入力文字数は30文字 | E-01 (Line 12 maxlength="30") | ○ |
| C-15 | 機能No.4「パスワード変更」に対応 | E-03 | ○ |
| C-16 | tblSecondAdminのsPasswordカラムに保存 | E-02 (Line 108) | ○ |
| C-17 | QS_secCodeHiddenでCSRFトークン出力 | E-01 (Line 12) | ○ |
| C-18 | 確認ダイアログを表示 | E-01 (Line 12 onclick="javascript:return confirm") | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全機能がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルールが正確に記述されているか
- [ ] SHA256ハッシュ化の説明が適切か
- [ ] エラーメッセージ一覧に漏れがないか
- [ ] リダイレクト先URLが正確か
