---
generated_at: 2026-01-23 23:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：119-イントラネットメニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **cls_menuクラスの実装詳細**：推定パスで、実際のファイルを確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_menuIntranet.asp` - イントラネットメニュー表示（24行）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 157）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 120）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_menuIntranet.aspで実装されている | E-01 | ○ |
| C-02 | bs_intranet.aspからインクルードされる | E-01（使用パターン） | ○ |
| C-03 | cls_menu.getBOMenu(null,true)でメニュー取得 | E-01 (Line 3-4) | ○ |
| C-04 | 第2引数trueはイントラネットモード | E-01 (Line 4) | ○ |
| C-05 | lossePaginas(true)でフリーページ取得 | E-01 (Line 5-6) | ○ |
| C-06 | フリーページはulタグ内にリスト表示 | E-01 (Line 8) | ○ |
| C-07 | getClickLink(true)でページリンク生成 | E-01 (Line 12) | ○ |
| C-08 | sApplicationでアプリケーションアイコン表示判定 | E-01 (Line 13) | ○ |
| C-09 | bPagesAddでコピーアイコン表示制御 | E-01 (Line 14) | ○ |
| C-10 | bPagesPWでパスワードアイコン表示制御 | E-01 (Line 15-16) | ○ |
| C-11 | sPwでロック/アンロックアイコン切り替え | E-01 (Line 15-16) | ○ |
| C-12 | bPagesMoveで移動アイコン表示制御 | E-01 (Line 18) | ○ |
| C-13 | コピーはbs_default.aspに遷移 | E-01 (Line 14) | ○ |
| C-14 | パスワード管理はbs_applyPw.aspに遷移 | E-01 (Line 16) | ○ |
| C-15 | 移動はbs_selectPage.aspに遷移 | E-01 (Line 18) | ○ |
| C-16 | EnCrypt()でページIDを暗号化 | E-01 (Line 14, 16, 18) | ○ |
| C-17 | getIcon()関数でアイコン生成 | E-01 (Line 13, 14, 16, 18) | ○ |
| C-18 | cls_menuクラスの実装詳細 | **推定パス** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_menuクラスの実際のファイルパスと実装内容（C-18）
  - 候補：asp/includes/menu.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の機能がコードで確認可能
- 1: 中リスク - cls_menuクラスの詳細実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御の条件が正確か
- [ ] 各遷移先URLが正確か
- [ ] ページIDの暗号化処理が適切か
- [ ] cls_menuクラスの実際の実装を確認
