---
generated_at: 2026-01-23 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-外部URL編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **cls_urlTypeListの詳細仕様**：プロトコル選択肢の完全なリスト確認が必要
  2. **Colorbox統合の動作確認**：QSCCB_530_300クラスの実際の動作検証が必要
  3. **権限制御の完全性**：secondAdmin各プロパティの影響範囲確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editExternalURL.asp` - メイン画面ソースコード
- E-02: `asp/bs_processPage.asp` - 保存・削除処理
- E-03: `asp/bs_process.asp` - 共通処理
- E-04: `asp/bs_commoncont.asp` - タイトル入力部品
- E-05: `asp/bs_sortorder.asp` - 表示順選択部品
- E-06: `asp/bs_onlineOrNot.asp` - 公開設定部品
- E-07: `asp/bs_deleteButton.asp` - 削除ボタン部品
- E-08: `asp/includes/page.asp` - cls_pageクラス
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.12は外部URL編集画面である | E-09 | ○ |
| C-02 | URLパスはasp/bs_editExternalURL.aspである | E-01, E-09 | ○ |
| C-03 | sExternalURLPrefixでプロトコル選択 | E-01 | ○ |
| C-04 | sExternalURLでURL本体を入力 | E-01 | ○ |
| C-05 | bOpenInNewWindowで新窓設定 | E-01 | ○ |
| C-06 | sRelでrel属性を設定 | E-01 | ○ |
| C-07 | sClassnameでclass属性を設定 | E-01 | ○ |
| C-08 | QSCCB_530_300でColorbox連携 | E-01（コメント記載） | ○ |
| C-09 | bs_processPage.aspで保存処理 | E-01, E-02 | ○ |
| C-10 | page.getRequestValues()で値取得 | E-02 (行14) | ○ |
| C-11 | page.save()で保存実行 | E-02 (行15) | ○ |
| C-12 | 削除は論理削除（bDeleted=true） | E-02 (行28-29) | ○ |
| C-13 | checkCSRF()でトークン検証 | E-02 (行13) | ○ |
| C-14 | secondAdmin.bPageBodyで表示制御 | E-01 | ○ |
| C-15 | secondAdmin.bPageTitleで編集制御 | E-04 | ○ |
| C-16 | bs_commoncont.aspでタイトル入力 | E-01, E-04 | ○ |
| C-17 | bs_sortorder.aspで表示順選択 | E-01, E-05 | ○ |
| C-18 | bs_onlineOrNot.aspで公開設定 | E-01, E-06 | ○ |
| C-19 | bs_deleteButton.aspで削除ボタン | E-01, E-07 | ○ |
| C-20 | 関連機能は外部URL設定(No.14) | E-10 | ○ |
| C-21 | 変換リンクが3種類提供される | E-01 | ○ |
| C-22 | cls_urlTypeListのプロトコル一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_urlTypeListクラスの定義ファイルが未確認のため、利用可能なプロトコル一覧（http://、https://、mailto:、ftp://等）の完全なリストが確認できていない
  - 候補：cls_urlTypeList.asp / includes/urlTypeList.asp / 設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な入出力項目はソースコードから明確に確認可能
- 1: 中リスク - プロトコル選択肢の完全性は追加調査が必要
- 0: 低リスク - 権限制御の仕組みはコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cls_urlTypeListクラスの定義を確認し、利用可能なプロトコル一覧を検証
- [ ] Colorboxクラス（QSCCB_*）の動作を実際に確認
- [ ] 各secondAdminプロパティの影響範囲を確認
- [ ] ページタイプ変換機能の動作確認
- [ ] イントラネットページの場合の遷移先確認
