---
generated_at: 2026-01-23 23:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-メール履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_mailHistory.asp` - メール履歴画面（14行）
- E-02: `asp/includes/mail.asp` - cls_mailクラス定義（68行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（Line 158）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面情報（Line 121）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_mailHistory.aspで実装されている | E-01 | ○ |
| C-02 | bIntranetMail権限でアクセス制御 | E-01 (Line 4) | ○ |
| C-03 | iMail_IDパラメータで削除対象を指定 | E-01 (Line 6) | ○ |
| C-04 | checkCSRF()でCSRF検証 | E-01 (Line 7) | ○ |
| C-05 | theMail.delete()でメール削除 | E-01 (Line 8) | ○ |
| C-06 | customer.mailsでメール一覧取得 | E-01 (Line 11) | ○ |
| C-07 | テーブルはsortableクラスを持つ | E-01 (Line 12) | ○ |
| C-08 | openPopUpWindowでポップアップ表示 | E-01 (Line 12) | ○ |
| C-09 | bs_mailDetail.aspへのリンク（件名クリック） | E-01 (Line 12) | ○ |
| C-10 | bs_mailReceivers.aspへのリンク（受信者数クリック） | E-01 (Line 12) | ○ |
| C-11 | ポップアップサイズ670x500（メール詳細） | E-01 (Line 12) | ○ |
| C-12 | ポップアップサイズ390x700（受信者一覧） | E-01 (Line 12) | ○ |
| C-13 | 確認ダイアログで削除確認 | E-01 (Line 12) | ○ |
| C-14 | convertEuroDateで日付変換 | E-01 (Line 12) | ○ |
| C-15 | encrypt/decryptでID暗号化 | E-01 (Line 12), E-02 (Line 6) | ○ |
| C-16 | delete()でtblMailContactも削除 | E-02 (Line 47-48) | ○ |
| C-17 | delete()でtblMailも削除 | E-02 (Line 49-50) | ○ |
| C-18 | iNumberRecで受信者数取得 | E-02 (Line 53-57) | ○ |
| C-19 | 機能No.87「メール送信履歴」に対応 | E-03 | ○ |
| C-20 | メールなしの場合「nomessagessent」表示 | E-01 (Line 13) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全機能がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 削除処理のフローが正確か
- [ ] ポップアップウィンドウのサイズが正確か
- [ ] 表示項目一覧に漏れがないか
- [ ] CSRF対策が適切に説明されているか
