---
generated_at: 2026-01-23 10:32:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：122-メール受信者

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **tblMailContactテーブル構造**：テーブル定義ファイルが未確認
  2. **receiversメソッドの詳細実装**：クラスファイルが見つからず、実装詳細が推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_mailReceivers.asp` - メール受信者一覧画面のソースコード（13行）
- E-02: `asp/bs_mailHistory.asp` - メール履歴画面のソースコード
- E-03: `asp/bs_massMailing2.asp` - 一斉メール送信処理（tblMailContact参照あり）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能のマッピング情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_mailReceivers.aspで実装されている | E-01 | ○ |
| C-02 | cls_mailクラスをインスタンス化 | E-01 行5 | ○ |
| C-03 | receiversメソッドで受信者配列を取得 | E-01 行6 | ○ |
| C-04 | 配列をループしてolリストで出力 | E-01 行7-12 | ○ |
| C-05 | secondAdmin.bIntranetMail権限が必要 | E-01 行4 | ○ |
| C-06 | ポップアップウィンドウ（390x700px）で表示 | E-02 行12 openPopUpWindow関数 | ○ |
| C-07 | iMail_idパラメータで暗号化されたメールIDを受け取る | E-02 encrypt(mail)の使用 | ○ |
| C-08 | メール履歴画面から遷移 | E-02 リンク構造 | ○ |
| C-09 | tblMailContactテーブルにsEmailとiMailIDが存在 | E-03 行77-78 | ○ |
| C-10 | receiversは2次元配列で(0,i)がメールアドレス | E-01 行10 receivers(0,i) | ○ |
| C-11 | counterパラメータで受信者数を取得 | E-01 行6 receivers(counter) | ○ |
| C-12 | 機能No.87（メール送信履歴）に関連 | E-04 | ○ |
| C-13 | tblMailContactの完全なテーブル構造 | **根拠なし** | △ |
| C-14 | receiversメソッドの内部実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- receiversメソッドの内部実装（SQLクエリの詳細）
  - 候補：cls_mailクラス定義ファイル / インクルードファイル内での定義
- tblMailContactテーブルの完全なスキーマ
  - 候補：データベーススキーマファイル / SQLスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本的な処理フローは確認済み
- 0: 低リスク - tblMailContactへの書き込みはbs_massMailing2.aspで確認済みで、テーブルの存在は確実

## 6) レビュアーチェックリスト（最小）
- [ ] receiversメソッドのSQLクエリを確認
- [ ] tblMailContactテーブルの全カラムを確認
- [ ] 大量の受信者がいる場合のパフォーマンスを確認
- [ ] 受信者が0件の場合の表示を確認
