---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：123-一斉メール送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **cls_mail_messageクラスの詳細実装**：send()メソッドの内部実装（SMTP設定等）が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_massMailing2.asp` - 一斉メール送信処理のソースコード（83行）
- E-02: `asp/bs_massMailingFB.asp` - 送信完了フィードバック画面
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能のマッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_massMailing2.aspで実装 | E-01 | ○ |
| C-02 | server.ScriptTimeoutを10000秒に設定 | E-01 行6 | ○ |
| C-03 | contactDictでDictionaryオブジェクト作成 | E-01 行7-8 | ○ |
| C-04 | cls_mail_messageでメールオブジェクト作成 | E-01 行11 | ○ |
| C-05 | hSubject、hBodyをPOSTから取得 | E-01 行13-14 | ○ |
| C-06 | ccEmailsとcontactIDsをsplitで配列化 | E-01 行16-17 | ○ |
| C-07 | decrypt関数で連絡先IDを復号化 | E-01 行22 | ○ |
| C-08 | cls_contactで連絡先情報を取得 | E-01 行21-22 | ○ |
| C-09 | [email]プレースホルダを置換 | E-01 行28-30 | ○ |
| C-10 | [sPw]プレースホルダを置換 | E-01 行29-31 | ○ |
| C-11 | カスタムフィールドのプレースホルダ置換 | E-01 行32-41 | ○ |
| C-12 | 日付型フィールドは特別処理 | E-01 行34-36 select case sb_date | ○ |
| C-13 | contactDictで重複チェック | E-01 行24 | ○ |
| C-14 | theMail.send()でメール送信 | E-01 行44 | ○ |
| C-15 | CC宛先への送信ループ | E-01 行49-56 | ○ |
| C-16 | CheckEmailSyntaxでCC宛先検証 | E-01 行50 | ○ |
| C-17 | mailobj.save()で履歴保存 | E-01 行69 | ○ |
| C-18 | tblMailContactへの送信先記録 | E-01 行71-79 | ○ |
| C-19 | bs_massMailingFB.aspにリダイレクト | E-01 行80 | ○ |
| C-20 | cls_mail_messageのsend()メソッドの内部実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_mail_messageクラスのsend()メソッド内部実装
  - 候補：asp/classes/ 配下のクラス定義ファイル / インクルードファイル内
- SMTP接続設定の詳細
  - 候補：Application変数 / web.config / 設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理フローはソースコードで完全に確認済み
- 1: 中リスク - 大量送信時のパフォーマンスとエラーハンドリングの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] cls_mail_messageのsend()メソッド実装を確認
- [ ] SMTP接続設定の場所を確認
- [ ] ErrorReport関数の実装を確認
- [ ] 大量送信時のメモリ使用量を確認
- [ ] On Error Resume Nextのエラーハンドリング範囲を確認
