---
generated_at: 2026-01-23 10:38:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：124-FBメール送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_massMailingFB.asp` - フィードバック画面のソースコード（5行）
- E-02: `asp/bs_massMailing2.asp` - 遷移元の一斉送信処理（リダイレクト行80）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能のマッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_massMailingFB.aspで実装 | E-01 | ○ |
| C-02 | secondAdmin.bIntranetMail権限が必要 | E-01 行4 | ○ |
| C-03 | request.querystring("counter")で送信件数取得 | E-01 行4 | ○ |
| C-04 | l("messagessent")で多言語メッセージ表示 | E-01 行4 | ○ |
| C-05 | bs_mailHistory.aspへのリンク表示 | E-01 行4 | ○ |
| C-06 | l("sentmessages")でリンクテキスト表示 | E-01 行4 | ○ |
| C-07 | getBOHeader(btn_Intranet)でメニュー表示 | E-01 行4 | ○ |
| C-08 | getBOHeaderIntranet(btn_sentmessages)でサブメニュー | E-01 行4 | ○ |
| C-09 | bs_massMailing2.aspからリダイレクトで遷移 | E-02 行80 | ○ |
| C-10 | counterパラメータがリダイレクト時に付与される | E-02 行80 | ○ |
| C-11 | 機能No.86（一括メール送信）に関連 | E-03 | ○ |
| C-12 | データベースアクセスなし | E-01（DB操作コードなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな結果表示画面で、すべての処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 多言語ラベル（messagessent、sentmessages）が全言語で定義されているか確認
- [ ] counterが非数値の場合の表示を確認
