---
generated_at: 2026-01-23 10:41:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：125-アセットマネージャー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_assetmanager.asp` - アセットマネージャー画面のソースコード（5行）
- E-02: `asp/assetmanager/assetmanagerIF.asp` - iframe内コンテンツ（671行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能のマッピング情報
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_assetmanager.aspで実装 | E-01 | ○ |
| C-02 | secondAdmin.bFiles権限が必要 | E-01 行4 | ○ |
| C-03 | session("showInsertButton")=falseを設定 | E-01 行4 | ○ |
| C-04 | iframeでassetmanagerIF.aspを埋め込み | E-01 行4 | ○ |
| C-05 | iframeサイズは910x450px | E-01 行4 style属性 | ○ |
| C-06 | frameborder=0で境界線なし | E-01 行4 | ○ |
| C-07 | getBOHeader(btn_Folder)でメニュー表示 | E-01 行4 | ○ |
| C-08 | C_DIRECTORY_QUICKERSITEでパス取得 | E-01 行4 | ○ |
| C-09 | 機能No.37（アセットマネージャー）に関連 | E-03 | ○ |
| C-10 | 実際のファイル操作はassetmanagerIF.aspで実行 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなiframeコンテナ画面で、すべての処理がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] C_DIRECTORY_QUICKERSITE定数の定義場所を確認
- [ ] showInsertButtonがtrueの場合の動作を確認（ファイル選択モード）
