---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：126-アセットマネージャーIF

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/assetmanager/assetmanagerIF.asp` - メインインターフェース（671行）
- E-02: `asp/assetmanager/security.asp` - セッション認証（8行）
- E-03: `asp/assetmanager/settings.asp` - 設定ファイル（21行）
- E-04: `asp/assetmanager/i_upload_object_FSO.asp` - アップロードクラス（311行）
- E-05: `asp/assetmanager/foldernew.asp` - フォルダ作成（81行）
- E-06: `asp/assetmanager/folderdel.asp` - フォルダ削除確認（49行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はassetmanagerIF.aspで実装 | E-01 | ○ |
| C-02 | security.aspでセッション認証 | E-02 行7 | ○ |
| C-03 | arrBaseFolder配列で4つのベースフォルダ定義可能 | E-03 行2-4 | ○ |
| C-04 | bReturnAbsoluteで絶対パス返却設定 | E-03 行7-8 | ○ |
| C-05 | showInsertButton/showSelectButtonフラグ対応 | E-01 行5-17 | ○ |
| C-06 | recursive関数でフォルダ階層構築 | E-01 行80-99 | ○ |
| C-07 | writeFileSelections関数でファイル一覧生成 | E-01 行110-264 | ○ |
| C-08 | ファイルタイプ別アイコン表示 | E-01 行203-233 | ○ |
| C-09 | changeFolder関数でフォルダ切替 | E-01 行339-348 | ○ |
| C-10 | selectFile関数でファイル選択・プレビュー | E-01 行407-485 | ○ |
| C-11 | deleteFile関数でファイル削除 | E-01 行486-498 | ○ |
| C-12 | upload関数でファイルアップロード | E-01 行349-369 | ○ |
| C-13 | newFolder関数でfoldernew.asp呼び出し | E-01 行377-383 | ○ |
| C-14 | deleteFolder関数でfolderdel.asp呼び出し | E-01 行384-401 | ○ |
| C-15 | applyFilter関数でフィルタ適用 | E-01 行319-328 | ○ |
| C-16 | Uploadクラスでファイルアップロード処理 | E-04 行13-233 | ○ |
| C-17 | 許可ファイルタイプリスト | E-04 行245 | ○ |
| C-18 | 最大ファイルサイズ150MB | E-04 行246 | ○ |
| C-19 | CKEditor連携（CKEditorFuncNum） | E-01 行520-531 | ○ |
| C-20 | プレビュー対応形式（画像/SWF/動画/音声） | E-01 行425-465 | ○ |
| C-21 | 確認ダイアログ表示（ファイル削除時） | E-01 行488 getTxt | ○ |
| C-22 | ベースフォルダ削除防止チェック | E-01 行388-395 | ○ |
| C-23 | FileSystemObjectでファイル操作 | E-04 行226-231 | ○ |
| C-24 | multipart/form-dataでアップロード | E-01 行622 enctype属性 | ○ |
| C-25 | 機能No.37に関連 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 詳細なソースコードが確認済みで、すべての機能が検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] 許可ファイルタイプリストが最新のセキュリティ要件を満たしているか確認
- [ ] 150MBの最大ファイルサイズが適切か確認
- [ ] bReadOnly権限設定が正しく機能しているか確認
- [ ] パストラバーサル攻撃対策が十分か確認
