---
generated_at: 2026-01-23 10:48:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：127-フォルダ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/assetmanager/foldernew.asp` - フォルダ作成ダイアログ（81行）
- E-02: `asp/assetmanager/security.asp` - セッション認証（8行）
- E-03: `asp/assetmanager/assetmanagerIF.asp` - 呼び出し元（行377-383）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はfoldernew.aspで実装 | E-01 | ○ |
| C-02 | security.aspインクルードで認証 | E-01 行1 | ○ |
| C-03 | POSTでinpCurrFolder、inpNewFolderName受け取り | E-01 行4-5 | ○ |
| C-04 | FileSystemObject.FolderExistsで存在チェック | E-01 行8 | ○ |
| C-05 | FileSystemObject.CreateFolderで作成 | E-01 行12 | ○ |
| C-06 | On Error Resume Nextでエラー処理 | E-01 行11 | ○ |
| C-07 | 「Folder already exists.」メッセージ | E-01 行9 | ○ |
| C-08 | 「Folder created.」メッセージ | E-01 行16 | ○ |
| C-09 | 「Invalid input.」メッセージ | E-01 行14, 46-47 | ○ |
| C-10 | doPreSubmitで親ウィンドウからcurrFolder取得 | E-01 行39-42 | ○ |
| C-11 | dialogArguments(IE)/window.opener(Other)使い分け | E-01 行39-42 | ○ |
| C-12 | close & refreshで親ウィンドウ.changeFolder()呼び出し | E-01 行75 | ○ |
| C-13 | assetmanagerIF.aspからモーダルダイアログ呼び出し | E-03 行377-383 | ○ |
| C-14 | ダイアログサイズ250x192px(IE)/250x150px(Other) | E-03 行380, 382 | ○ |
| C-15 | 機能No.37に関連 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなフォルダ作成処理で、すべてのロジックがソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] フォルダ名に特殊文字（\, /, :, *, ?, ", <, >, |）が含まれる場合の処理を確認
- [ ] パストラバーサル攻撃（../）対策を確認
- [ ] 日本語フォルダ名の文字コード処理を確認
