---
generated_at: 2026-01-23 10:51:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：128-フォルダ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/assetmanager/folderdel.asp` - 削除確認ダイアログ（49行）
- E-02: `asp/assetmanager/folderdel_.asp` - 削除実行画面（62行）
- E-03: `asp/assetmanager/security.asp` - セッション認証（8行）
- E-04: `asp/assetmanager/assetmanagerIF.asp` - 呼び出し元（行384-401, 329-338）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 確認画面はfolderdel.aspで実装 | E-01 | ○ |
| C-02 | 実行画面はfolderdel_.aspで実装 | E-02 | ○ |
| C-03 | security.aspインクルードで認証 | E-01 行1, E-02 行1 | ○ |
| C-04 | del()関数で親ウィンドウからcurrFolder取得 | E-01 行18-22 | ○ |
| C-05 | Form1をfolderdel_.aspにsubmit | E-01 行33 action属性 | ○ |
| C-06 | FileSystemObject.FolderExistsで存在チェック | E-02 行7 | ○ |
| C-07 | GetParentFolderNameで親フォルダ取得 | E-02 行8 | ○ |
| C-08 | DeleteFolderで削除実行 | E-02 行10 | ○ |
| C-09 | 「Folder deleted.」メッセージ | E-02 行11 | ○ |
| C-10 | 「Folder does not exist.」メッセージ | E-02 行13 | ○ |
| C-11 | inpDestに親フォルダパス設定 | E-02 行48 | ○ |
| C-12 | refresh()で親ウィンドウのrefreshAfterDelete呼び出し | E-02 行34-37 | ○ |
| C-13 | deleteFolder関数でベースフォルダチェック | E-04 行388-395 | ○ |
| C-14 | 「Cannot delete Asset Base Folder.」アラート | E-04 行393 | ○ |
| C-15 | refreshAfterDelete関数で削除後の更新 | E-04 行329-338 | ○ |
| C-16 | dialogArguments(IE)/window.opener(Other)使い分け | E-01 行19-22, E-02 行35-37 | ○ |
| C-17 | ダイアログサイズ250x192px(IE)/250x150px(Other) | E-04 行398, 400 | ○ |
| C-18 | 機能No.37に関連 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 2画面構成のシンプルな削除処理で、すべてのロジックがソースコードで確認済み
- 1: 中リスク - フォルダ内にファイルが存在する場合の動作確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] フォルダ内にファイルが存在する場合の削除動作を確認
- [ ] 読み取り専用ファイルが含まれる場合のエラーハンドリングを確認
- [ ] ベースフォルダ以外の重要フォルダの保護が必要か検討
