---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-コンテナ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **子ページ管理の動作確認**：コンテナページ作成後の子ページ追加フローの検証
  2. **変換機能の動作確認**：コンテンツ付き/外部URLへの変換が正常動作するか
  3. **sCodeの一意性制約**：重複チェックの動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editContainer.asp` - メイン画面ソースコード
- E-02: `asp/bs_processPage.asp` - 保存・削除処理
- E-03: `asp/bs_commoncont.asp` - タイトル入力部品
- E-04: `asp/bs_sortorder.asp` - 表示順選択部品
- E-05: `asp/bs_onlineOrNot.asp` - 公開設定部品
- E-06: `asp/bs_sCode.asp` - sCode入力部品
- E-07: `asp/bs_deleteButton.asp` - 削除ボタン部品
- E-08: `asp/includes/page.asp` - cls_pageクラス
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.13はコンテナ編集画面である | E-09 | ○ |
| C-02 | URLパスはasp/bs_editContainer.aspである | E-01, E-09 | ○ |
| C-03 | bContainerPage=1をhiddenで送信 | E-01 | ○ |
| C-04 | タイトル入力はbs_commoncont.asp | E-01, E-03 | ○ |
| C-05 | 表示順はbs_sortorder.asp | E-01, E-04 | ○ |
| C-06 | 公開設定はbs_onlineOrNot.asp | E-01, E-05 | ○ |
| C-07 | sCode入力はbs_sCode.asp | E-01, E-06 | ○ |
| C-08 | bs_sCodeはcustomer.bApplicationで制御 | E-06 | ○ |
| C-09 | bs_sCodeはsecondAdmin.bApplicationpathで制御 | E-06 | ○ |
| C-10 | 削除ボタンはbs_deleteButton.asp | E-01, E-07 | ○ |
| C-11 | bs_processPage.aspで保存処理 | E-01, E-02 | ○ |
| C-12 | page.getRequestValues()で値取得 | E-02 | ○ |
| C-13 | page.save()で保存実行 | E-02 | ○ |
| C-14 | 削除は論理削除（bDeleted=true） | E-02 | ○ |
| C-15 | checkCSRF()でトークン検証 | E-02 | ○ |
| C-16 | 関連機能はコンテナページ管理(No.18) | E-10 | ○ |
| C-17 | 補助機能はページ移動・並び替え(No.11) | E-10 | ○ |
| C-18 | 変換リンクが2種類提供される | E-01 | ○ |
| C-19 | sCodeは最大48文字 | E-06 | ○ |
| C-20 | cls_pageクラスでデータ管理 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して根拠が確認できた
- 0: 低リスク - コンテナページの基本構造は明確
- 1: 中リスク - 子ページ管理のUI/UXフローは実際の動作確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] コンテナページ作成後、子ページを追加できることを確認
- [ ] sCodeの重複入力時にエラーが表示されることを確認
- [ ] コンテンツ付き/外部URLへの変換が正常に動作することを確認
- [ ] イントラネットページの場合の遷移先確認
- [ ] 子ページがあるコンテナの削除時の挙動確認
