---
generated_at: 2026-01-23 10:57:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：130-マルチファイルアップロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_multifileupload.asp` - マルチアップロードUI（50行）
- E-02: `asp/uploader214.asp` - アップロード受信処理（27行）
- E-03: `asp/uploaderCLS.asp` - Uploaderクラス（382行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はbs_multifileupload.aspで実装 | E-01 | ○ |
| C-02 | secondAdmin.bFiles権限が必要 | E-01 行4 | ○ |
| C-03 | cls_fileexplorerでフォルダ一覧取得 | E-01 行5 | ○ |
| C-04 | Application("mupath")にアップロード先設定 | E-01 行6 | ○ |
| C-05 | Application("UserIP")にユーザーIP設定 | E-01 行7 | ○ |
| C-06 | Application("sessionID")にセッションID設定 | E-01 行8 | ○ |
| C-07 | Uploadify v2.1.4を使用 | E-01 行9 jquery.uploadify.v2.1.4.min.js | ○ |
| C-08 | uploader214.aspをscriptに指定 | E-01 行16 | ○ |
| C-09 | sizeLimit: 1324000 | E-01 行18 | ○ |
| C-10 | allowedFileTypesから許可タイプ生成 | E-01 行19-29 | ○ |
| C-11 | multi: trueで複数選択可 | E-01 行31 | ○ |
| C-12 | auto: trueで自動アップロード | E-01 行32 | ○ |
| C-13 | onErrorでエラーハンドリング | E-01 行33-42 | ○ |
| C-14 | onCompleteでファイルリスト更新 | E-01 行43-46 | ○ |
| C-15 | Send_document関数でuploadifyUpload呼び出し | E-01 行10-12 | ○ |
| C-16 | フォルダ選択でform submit | E-01 行49 onchange | ○ |
| C-17 | SelectBoxFoldersでフォルダ選択肢生成 | E-01 行49 | ○ |
| C-18 | assetmanagerIF.aspへのリンク | E-01 行49 | ○ |
| C-19 | jQuery 1.5を使用 | E-01 行9 | ○ |
| C-20 | 機能No.38に関連 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての処理がソースコードで確認済み
- 1: 中リスク - Uploadify（Flash）は現代のブラウザでサポートが制限される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Uploadify（Flash）のブラウザ互換性を確認
- [ ] allowedFileTypes配列の定義場所と内容を確認
- [ ] sizeLimit（1.3MB）が要件に適合しているか確認
- [ ] cls_fileexplorerクラスの実装を確認
