---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：135-顧客一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **sortable JavaScriptライブラリ**：使用しているソート機能の実装確認
  2. **暗号化関数encrypt()の実装**：セキュリティ観点での確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_clientList.asp` - メインソースコード（行1-9）
- E-02: `asp/includes/client.asp` - クライアントクラス定義（行1-119）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.135）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「顧客一覧」 | E-03 | ○ |
| C-02 | ファイルパスは「asp/ad_clientList.asp」 | E-01, E-03 | ○ |
| C-03 | listAll()でクライアント一覧を取得 | E-01（行6）, E-02（行71-81） | ○ |
| C-04 | sortableクラスでソート可能 | E-01（行7） | ○ |
| C-05 | sNameでASC順にソート | E-02（行74） | ○ |
| C-06 | iId,sName,sContactPerson,sMainEmailを取得 | E-02（行74） | ○ |
| C-07 | 暗号化されたIDで遷移 | E-01（行7） | ○ |
| C-08 | mailto:リンクでメール | E-01（行7） | ○ |
| C-09 | ad_client.aspに遷移 | E-01（行7） | ○ |
| C-10 | 機能Noは8（ページ一覧） | E-04 | ○ |
| C-11 | ad_adminMenu.aspをインクルード | E-01（行4） | ○ |
| C-12 | ad_security.aspで認証 | E-01（行4） | ○ |
| C-13 | beginClient.aspをインクルード | E-01（行4） | ○ |
| C-14 | 連番を表示 | E-01（行7、i+1） | ○ |
| C-15 | quotRep()でサニタイズ | E-01（行7） | ○ |

## 4) 不足情報（Unknown / Missing）
- sortableテーブルのJavaScript実装詳細
  - 候補：共通JavaScript / 外部ライブラリ
- encrypt/decrypt関数の詳細実装
  - 候補：encryption.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 0: 低リスク - quotRep()でXSS対策が実装されている
- 0: 低リスク - 管理者認証が必須

## 6) レビュアーチェックリスト（最小）
- [ ] sortableテーブルの動作確認
- [ ] クライアントIDの暗号化が適切か確認
- [ ] メールアドレスのサニタイズが適切か確認
- [ ] 大量クライアント時のパフォーマンス確認
