---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：136-顧客詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **削除時のカスケード処理**：製品情報も削除されることの確認
  2. **CSRF対策の実装**：checkCSRF()の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_client.asp` - メインソースコード（行1-23）
- E-02: `asp/includes/client.asp` - クライアントクラス定義（行1-119）
- E-03: `asp/includes/clientproduct.asp` - 製品クラス定義（行1-106）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.136）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「顧客詳細」 | E-04 | ○ |
| C-02 | ファイルパスは「asp/ad_client.asp」 | E-01, E-04 | ○ |
| C-03 | 必須項目はsName,sContactPerson,sMainEmail | E-02（行12-24） | ○ |
| C-04 | client.save()で保存 | E-01（行13）, E-02（行44-69） | ○ |
| C-05 | client.remove()で削除 | E-01（行19）, E-02（行96-104） | ○ |
| C-06 | 削除時に関連製品も削除 | E-02（行99） | ○ |
| C-07 | CSRF検証を実行 | E-01（行18） | ○ |
| C-08 | 確認ダイアログを表示 | E-01（行21） | ○ |
| C-09 | productsプロパティで製品一覧取得 | E-01（行6）, E-02（行105-117） | ○ |
| C-10 | 削除後にad_clientList.aspにリダイレクト | E-01（行20） | ○ |
| C-11 | 新規作成時は削除ボタン非表示 | E-01（行21） | ○ |
| C-12 | 機能Noは5（サイト基本設定） | E-05 | ○ |
| C-13 | dCreatedTSに作成日時を設定 | E-02（行56） | ○ |
| C-14 | dUpdatedTSに更新日時を設定 | E-02（行65） | ○ |
| C-15 | fb_saveOKメッセージを表示 | E-01（行14） | ○ |
| C-16 | 製品追加リンクを表示 | E-01（行22） | ○ |
| C-17 | 既存クライアントのみ製品一覧表示 | E-01（行21） | ○ |
| C-18 | quotRep()でサニタイズ | E-01（行21） | ○ |

## 4) 不足情報（Unknown / Missing）
- checkCSRF()関数の詳細実装
  - 候補：共通セキュリティファイル
- message.Add()によるメッセージ表示機構の詳細
  - 候補：messages.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 0: 低リスク - CSRF対策が実装されている
- 1: 中リスク - 削除時のカスケード処理の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 必須項目のバリデーションが適切か確認
- [ ] 削除時のカスケード処理が正しく動作するか確認
- [ ] メールアドレスの形式検証有無を確認
- [ ] 入力最大長の制限が適切か確認
