---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：137-顧客編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **IISバインディング更新処理**：cls_iisSiteクラスの詳細確認が必要
  2. **QS_defaultPWの値**：デフォルトパスワードのセキュリティ確認
  3. **SMTP設定の動作確認**：メール送信テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_customer.asp` - メインソースコード（行1-82）
- E-02: `asp/includes/customer.asp` - 顧客クラス定義（行1-1638）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.137）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「顧客編集」 | E-03 | ○ |
| C-02 | ファイルパスは「asp/ad_customer.asp」 | E-01, E-03 | ○ |
| C-03 | 必須項目はsName、sURL | E-02（行246-254） | ○ |
| C-04 | URL長は7文字以上必要 | E-02（行251-254） | ○ |
| C-05 | 新規作成時にデフォルトPW設定 | E-01（行17） | ○ |
| C-06 | adminPasswordはSHA256でハッシュ | E-02（行1206-1207） | ○ |
| C-07 | 自サイトは削除不可 | E-01（行71-72） | ○ |
| C-08 | URL変更時にIISバインディング更新 | E-01（行20-22）, E-02（行501-508） | ○ |
| C-09 | 機能Noは5（サイト基本設定） | E-04 | ○ |
| C-10 | SMTP設定項目を保存 | E-01（行39-44） | ○ |
| C-11 | 代替ドメインを保存 | E-01（行29） | ○ |
| C-12 | bListItemPicを保存 | E-01（行36） | ○ |
| C-13 | bShoppingCartを保存 | E-01（行37） | ○ |
| C-14 | CSRF検証を実行 | E-01（行12,60） | ○ |
| C-15 | 削除後にad_default.aspにリダイレクト | E-01（行62） | ○ |
| C-16 | 保存後にad_default.aspにリダイレクト | E-01（行52,55） | ○ |
| C-17 | dCreatedTS/dUpdatedTSを表示 | E-01（行75） | ○ |
| C-18 | アプリケーションリセットリンクを表示 | E-01（行75） | ○ |
| C-19 | SMTPポートデフォルトは25 | E-01（行77） | ○ |
| C-20 | 送信方式の選択肢は1/2/3 | E-01（行77） | ○ |
| C-21 | SSL使用の選択肢は0/1 | E-01（行79） | ○ |
| C-22 | IISバインディング更新の詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_iisSiteクラスの詳細実装（IISバインディング更新処理）
  - 候補：別途インクルードファイル
- QS_defaultPWの具体的な値
  - 候補：定数定義ファイル
- sha256関数の実装詳細
  - 候補：sha256.asp

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - IISバインディング更新処理の動作確認が必要
- 1: 中リスク - SMTP認証情報の保存方法（平文か暗号化か）
- 0: 低リスク - CSRF対策が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] IISバインディング更新が正しく動作するか確認
- [ ] デフォルトパスワードのセキュリティ確認
- [ ] SMTP設定によるメール送信テスト
- [ ] 自サイト削除防止が正しく機能するか確認
