---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：138-顧客製品一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **年間売上計算ロジック**：計算式の妥当性確認
  2. **色分け表示の閾値**：14日という基準の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_clientproducts.asp` - メインソースコード（行1-34）
- E-02: `asp/includes/clientproduct.asp` - 製品クラス定義（行1-106）
- E-03: `asp/includes/client.asp` - クライアントクラス定義（行1-119）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.138）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「顧客製品一覧」 | E-04 | ○ |
| C-02 | ファイルパスは「asp/ad_clientproducts.asp」 | E-01, E-04 | ○ |
| C-03 | list()で製品一覧を取得 | E-01（行6）, E-02（行85-97） | ○ |
| C-04 | sNameでASC順にソート | E-02（行89） | ○ |
| C-05 | クライアント名をDictionaryでキャッシュ | E-01（行11-14） | ○ |
| C-06 | 無料サービス（iPrice<=0）は色なし | E-01（行17-18） | ○ |
| C-07 | 終了済みサービスは色なし | E-01（行19-20） | ○ |
| C-08 | 更新日未設定は黄色 | E-01（行21-22） | ○ |
| C-09 | 更新期限14日以内はオレンジ | E-01（行23-24） | ○ |
| C-10 | 年間売上計算：料金×(12/更新月) | E-01（行30） | ○ |
| C-11 | 終了済み/無料は年間計算から除外 | E-01（行27-29） | ○ |
| C-12 | 機能Noは77（ショッピングカート管理） | E-05 | ○ |
| C-13 | sortableクラスでソート | E-01（行15） | ○ |
| C-14 | 暗号化されたIDで遷移 | E-01（行26） | ○ |
| C-15 | 連番を表示 | E-01（行16、i+1） | ○ |
| C-16 | convertEuroDate()で日付表示 | E-01（行26） | ○ |
| C-17 | 年間合計をフッターに表示 | E-01（行33） | ○ |
| C-18 | dateAdd()で更新期限計算 | E-01（行23） | ○ |

## 4) 不足情報（Unknown / Missing）
- dateAdd関数の詳細仕様（VBScript標準関数）
  - 候補：Microsoft VBScript リファレンス
- convertEuroDate関数の実装詳細
  - 候補：functions.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 0: 低リスク - 年間売上計算ロジックは明確
- 0: 低リスク - 色分け表示の条件分岐は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 年間売上計算ロジックが業務要件と合致しているか確認
- [ ] 色分け表示の閾値（14日）が適切か確認
- [ ] 大量データ時のパフォーマンス確認
- [ ] 日付フォーマットが適切か確認
