---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：139-顧客製品詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **バリデーションロジック**：必須項目チェックの網羅性確認
  2. **デフォルト値設定**：日付とiRenewalの初期値確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_clientproduct.asp` - メインソースコード（行1-27）
- E-02: `asp/includes/clientproduct.asp` - 製品クラス定義（行1-106）
- E-03: `asp/includes/client.asp` - クライアントクラス定義（行1-119）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.139）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「顧客製品詳細」 | E-04 | ○ |
| C-02 | ファイルパスは「asp/ad_clientproduct.asp」 | E-01, E-04 | ○ |
| C-03 | 必須項目はsName、iClientID | E-02（行21-28） | ○ |
| C-04 | save()で保存処理 | E-01（行17）, E-02（行53-84） | ○ |
| C-05 | remove()で削除処理 | E-01（行23）, E-02（行98-104） | ○ |
| C-06 | CSRF検証を実行 | E-01（行22） | ○ |
| C-07 | 確認ダイアログを表示 | E-01（行26） | ○ |
| C-08 | dStartServiceのデフォルトはdate() | E-02（行7） | ○ |
| C-09 | dEndServiceのデフォルトは1年後 | E-02（行8） | ○ |
| C-10 | iRenewalのデフォルトは12 | E-02（行9） | ○ |
| C-11 | 機能Noは77（ショッピングカート管理） | E-05 | ○ |
| C-12 | 暗号化されたIDを使用 | E-01（行7, 18, 24, 26） | ○ |
| C-13 | FCKEditorでメモ編集 | E-01（行26） | ○ |
| C-14 | JQDatePickerで日付入力 | E-01（行26） | ○ |
| C-15 | 保存後にad_client.aspにリダイレクト | E-01（行18） | ○ |
| C-16 | 削除後にad_client.aspにリダイレクト | E-01（行24） | ○ |
| C-17 | 新規作成時は削除ボタン非表示 | E-01（行26） | ○ |
| C-18 | dCreatedTSに作成日時を設定 | E-02（行65） | ○ |
| C-19 | dUpdatedTSに更新日時を設定 | E-02（行79） | ○ |
| C-20 | 更新周期は0〜96ヶ月選択 | E-01（行26、numberList(0,96,1,...)） | ○ |

## 4) 不足情報（Unknown / Missing）
- createFCKInstance関数の詳細実装
  - 候補：共通インクルードファイル
- JQDatePicker関数の詳細実装
  - 候補：jQuery UI関連ファイル
- numberList関数の詳細実装
  - 候補：functions.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 0: 低リスク - バリデーションロジックが明確
- 0: 低リスク - CSRF対策が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 必須項目のバリデーションが適切か確認
- [ ] デフォルト値が業務要件と合致しているか確認
- [ ] 日付入力形式が適切か確認
- [ ] 料金・VAT入力の桁数制限が適切か確認
