---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ページブロック編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **WYSIWYGエディタの動作確認**：createFCKInstance関数の実際の動作検証
  2. **デフォルト値表示の正確性**：customerオブジェクトからの値取得確認
  3. **テンプレート内での使用方法**：[PAGE_BLOCK01]等のプレースホルダ置換処理の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editPageBlocks.asp` - メイン画面ソースコード
- E-02: `asp/includes/page.asp` - cls_pageクラス（sProp01-sProp08定義）
- E-03: `asp/bs_security.asp` - セキュリティ処理
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面No.14はページブロック編集画面である | E-04 | ○ |
| C-02 | URLパスはasp/bs_editPageBlocks.aspである | E-01, E-04 | ○ |
| C-03 | 8つのブロック（PAGE_BLOCK01〜08）を編集可能 | E-01 | ○ |
| C-04 | 奇数ブロックはtextareaで入力 | E-01 | ○ |
| C-05 | 偶数ブロックはWYSIWYGエディタで入力 | E-01（createFCKInstance） | ○ |
| C-06 | sProp01〜sProp08でデータ格納 | E-01, E-02 | ○ |
| C-07 | secondAdmin.bSetupPageElementsで権限制御 | E-01 (行4) | ○ |
| C-08 | logon.hasaccessで権限チェック | E-01 (行4) | ○ |
| C-09 | checkCSRF()でトークン検証 | E-01 (行8) | ○ |
| C-10 | removeEmptyP()で空のp要素を除去 | E-01 (行9-15) | ○ |
| C-11 | convertStr()で値をサニタイズ | E-01 (行9-15) | ○ |
| C-12 | page.save()で保存実行 | E-01 (行17) | ○ |
| C-13 | message.Add("fb_saveOK")で成功メッセージ | E-01 (行17) | ○ |
| C-14 | customerオブジェクトからデフォルト値取得 | E-01 | ○ |
| C-15 | textareaは幅480px | E-01 (style="width:480px") | ○ |
| C-16 | 関連機能はページブロック編集(No.19) | E-05 | ○ |
| C-17 | 背景色は白（#FFF） | E-01 (body style) | ○ |
| C-18 | message.showAlert()でアラート表示 | E-01 (行19) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全ての主張に根拠が確認された）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に対して根拠が確認できた
- 1: 中リスク - WYSIWYGエディタの設定プロファイル（siteBuilderMailSource）の詳細確認推奨
- 1: 中リスク - テンプレート内での[PAGE_BLOCK]プレースホルダ置換処理の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各ブロック（01〜08）への入力が正しく保存されることを確認
- [ ] WYSIWYGエディタ（偶数ブロック）が正常に動作することを確認
- [ ] デフォルト値（customer.sPropXX）が正しく表示されることを確認
- [ ] テンプレート内で[PAGE_BLOCK01]等が正しく置換されることを確認
- [ ] 権限のないユーザーがアクセスを拒否されることを確認
