---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：140-ページ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **訪問数/日計算ロジック**：aantalDagenWithDate()関数の確認
  2. **大量データ時のパフォーマンス**：全件表示時の負荷

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_pageList.asp` - メインソースコード（行1-10）
- E-02: `asp/includes/search.asp` - 検索クラス定義（行1-172）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義（No.140）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「ページ一覧」 | E-03 | ○ |
| C-02 | ファイルパスは「asp/ad_pageList.asp」 | E-01, E-03 | ○ |
| C-03 | allPages()で一覧取得 | E-01（行8）, E-02（行155-170） | ○ |
| C-04 | showAll=falseでTOP 250制限 | E-02（行158-160） | ○ |
| C-05 | updatedTS降順でソート | E-02（行161） | ○ |
| C-06 | bOnline=trueのみ取得 | E-02（行161） | ○ |
| C-07 | tblPage/tblCustomerをINNER JOIN | E-02（行161） | ○ |
| C-08 | ページタイトル30文字超で省略 | E-01（行8-9） | ○ |
| C-09 | 訪問数/日を計算 | E-01（行8） | ○ |
| C-10 | sortableクラスでソート | E-01（行8） | ○ |
| C-11 | formatTimeStamp()で日時整形 | E-01（行8） | ○ |
| C-12 | encrypt()でID暗号化 | E-01（行8） | ○ |
| C-13 | 新ウィンドウで開く | E-01（行8、target属性） | ○ |
| C-14 | recordCountで総数取得 | E-01（行8）, E-02（行167） | ○ |
| C-15 | getRows()で2次元配列取得 | E-02（行166） | ○ |
| C-16 | 「&」を「&amp;」にエスケープ | E-01（行8） | ○ |
| C-17 | 機能Noは5（サイト基本設定） | E-04 | ○ |
| C-18 | Show allリンクで全件表示 | E-01（行9） | ○ |

## 4) 不足情報（Unknown / Missing）
- aantalDagenWithDate()関数の詳細実装
  - 候補：functions.asp
- formatTimeStamp()関数の詳細実装
  - 候補：functions.asp
- C_DIRECTORY_QUICKERSITEの定数値
  - 候補：定数定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認可能
- 1: 中リスク - 全件表示時のパフォーマンス確認が必要
- 0: 低リスク - SQLインジェクション対策済み（パラメータなし）

## 6) レビュアーチェックリスト（最小）
- [ ] 訪問数/日の計算ロジックが正しいか確認
- [ ] 全件表示時のパフォーマンス確認
- [ ] タイトル省略表示が適切か確認
- [ ] 日時フォーマットが適切か確認
