---
generated_at: 2026-01-23 22:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：141-フォームエントリー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **詳細表示のポップアップ動作**：実際のブラウザ動作確認が必要
  2. **統計情報の表示タイミング**：詳細モードでのみ表示されることの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_formentries.asp` 4-24行目（詳細表示処理）
- E-02: `asp/ad_formentries.asp` 25-38行目（一覧表示処理）
- E-03: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-04: `asp/includes/submission.asp` 2-140行目（cls_submissionクラス定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 180行目
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 142行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-03 | ○ |
| C-02 | 最大250件まで表示される | E-02 (counter<250) | ○ |
| C-03 | iSubmissionIDパラメータで詳細表示 | E-01 | ○ |
| C-04 | cls_submissionでデータ取得 | E-01, E-04 | ○ |
| C-05 | フォーム送信データ一覧機能 | E-05 | ○ |
| C-06 | 新着順でソートされる | E-02 (order by desc) | ○ |
| C-07 | サイト名が表示される | E-02 | ○ |
| C-08 | フォーム名が表示される | E-02 | ○ |
| C-09 | 送信日時が表示される | E-02 | ○ |
| C-10 | ヨーロッパ日付形式を使用 | E-02 (convertEurodate) | ○ |
| C-11 | ポップアップで詳細表示 | E-01 (target="_new") | ○ |
| C-12 | 統計情報が表示される | E-01 (18-22行目) | ○ |
| C-13 | フィールド値がリスト表示 | E-01 (12-16行目) | ○ |
| C-14 | 3テーブル結合クエリ | E-02 (INNER JOIN) | ○ |
| C-15 | 未認証時リダイレクト | E-03 | ○ |
| C-16 | 画面No.141である | E-06 | ○ |
| C-17 | 詳細画面で同一フォーム件数表示 | **根拠なし** | △ |
| C-18 | サイト全体送信件数表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-17, C-18: コード内で統計情報のSQL実行は確認できるが、表示ラベルの正確な文言はコード内のハードコードを確認する必要がある
  - 候補：ad_formentries.asp 18-22行目のresponse.write文を直接確認

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - データ参照のみで更新処理がないため安全
- 1: 中リスク - 認証チェックの実装は単純だが正常に機能している

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、フォームエントリー画面にアクセスできることを確認
- [ ] 一覧が最大250件で制限されることを確認（大量データがある場合）
- [ ] 詳細表示がポップアップで正しく開くことを確認
- [ ] 統計情報が正しく計算・表示されることを確認
