---
generated_at: 2026-01-23 22:22:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：142-ゲストブックエントリー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_gbentries.asp` 9行目（TOP 50クエリ）
- E-02: `asp/ad_gbentries.asp` 14行目（サイト情報取得クエリ）
- E-03: `asp/ad_gbentries.asp` 17-18行目（日付・メッセージ表示）
- E-04: `asp/ad_gbentries.asp` 19行目（サイトリンク表示）
- E-05: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 181行目
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` 143行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-05 | ○ |
| C-02 | 最大50件まで表示される | E-01 (TOP 50) | ○ |
| C-03 | 投稿日時が表示される | E-03 (convertEurodate) | ○ |
| C-04 | 投稿内容が400文字で切り捨て | E-03 (left(...,400)) | ○ |
| C-05 | サイト名がリンクとして表示 | E-04 | ○ |
| C-06 | 新しいウィンドウで開く | E-04 (target="_new") | ○ |
| C-07 | 新着順でソートされる | E-01 (order by dCreatedTS desc) | ○ |
| C-08 | 3テーブル結合で取得 | E-02 (INNER JOIN) | ○ |
| C-09 | ゲストブック投稿管理機能 | E-06 | ○ |
| C-10 | 画面No.142である | E-07 | ○ |
| C-11 | quotRepでエスケープ | E-03 (quotrep) | ○ |
| C-12 | ゲストブック未存在時スキップ | E-02 (if not rs2.eof) | ○ |
| C-13 | 入力パラメータなし | E-01 | ○ |
| C-14 | 未認証時リダイレクト | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - データ参照のみで更新処理がないため安全
- 0: 低リスク - 認証チェックが適切に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、ゲストブックエントリー画面にアクセスできることを確認
- [ ] 一覧が最大50件で制限されることを確認
- [ ] 投稿内容が400文字で切り捨てられることを確認
- [ ] サイト名リンクが正しいURLで開くことを確認
