---
generated_at: 2026-01-23 22:24:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：143-リファラー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_refererList.asp` 5-11行目（SQLクエリ構築）
- E-02: `asp/ad_refererList.asp` 6行目（TOP 15000）
- E-03: `asp/ad_refererList.asp` 9行目（SQLインジェクション対策）
- E-04: `asp/ad_refererList.asp` 13-28行目（集計処理）
- E-05: `asp/ad_refererList.asp` 25行目（SortDictionary2）
- E-06: `asp/ad_refererList.asp` 30-35行目（詳細表示）
- E-07: `asp/ad_refererList.asp` 31行目（60文字切り捨て、title属性）
- E-08: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 182行目
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 144行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-08 | ○ |
| C-02 | 最大15,000件取得 | E-02 | ○ |
| C-03 | selectedname未指定で集計表示 | E-04 | ○ |
| C-04 | selectedname指定で詳細表示 | E-06 | ○ |
| C-05 | Dictionary で集計 | E-04 (statsDict) | ○ |
| C-06 | SortDictionary2でソート | E-05 | ○ |
| C-07 | 60文字で切り捨て表示 | E-07 | ○ |
| C-08 | ツールチップに全文表示 | E-07 (title属性) | ○ |
| C-09 | SQLインジェクション対策 | E-03 (replace) | ○ |
| C-10 | 参照元サイト一覧機能 | E-09 | ○ |
| C-11 | 画面No.143である | E-10 | ○ |
| C-12 | sortableクラス適用 | E-04 (class=sortable) | ○ |
| C-13 | 結果件数表示 | E-06 (selCounter) | ○ |
| C-14 | 新規ウィンドウでURL開く | E-07 (target="_blank") | ○ |
| C-15 | 未認証時リダイレクト | E-08 | ○ |
| C-16 | 日付降順でソート | E-01 (ORDER BY dTS desc) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - データ参照のみで更新処理がないため安全
- 1: 中リスク - SQLインジェクション対策は実装されているが、100文字制限の妥当性を確認

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、リファラー一覧画面にアクセスできることを確認
- [ ] 集計表示でサイト別のリファラー件数が正しく表示されることを確認
- [ ] サイト名クリックで詳細一覧に切り替わることを確認
- [ ] リファラーURLが正しくリンクされることを確認
- [ ] 60文字以上のURLが切り捨てられ、ツールチップに全文が表示されることを確認
