---
generated_at: 2026-01-23 22:26:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：144-モニター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_monitor.asp` 4-11行目（操作分岐処理）
- E-02: `asp/ad_monitor.asp` 6行目（turn=off処理）
- E-03: `asp/ad_monitor.asp` 8行目（turn=on処理）
- E-04: `asp/ad_monitor.asp` 10行目（turn=remove処理）
- E-05: `asp/ad_monitor.asp` 12-13行目（部分一致削除）
- E-06: `asp/ad_monitor.asp` 16行目（confirm ダイアログ）
- E-07: `asp/ad_monitor.asp` 17-22行目（表示件数制御）
- E-08: `asp/ad_monitor.asp` 25行目（SELECT クエリ）
- E-09: `asp/ad_monitor.asp` 31行目（詳細表示div）
- E-10: `asp/ad_monitor.asp` 37-38行目（統計情報表示）
- E-11: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 183行目
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` 145行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-11 | ○ |
| C-02 | デフォルト1,000件表示 | E-07 (showtot=1001) | ○ |
| C-03 | show5000=onで5,000件表示 | E-07 (showtot=5001) | ○ |
| C-04 | turn=offでモニターOFF | E-02 (bMonitor=false) | ○ |
| C-05 | turn=onでモニターON | E-03 (bMonitor=true) | ○ |
| C-06 | turn=removeでログ全削除 | E-04 (delete from tblMonitor) | ○ |
| C-07 | 確認ダイアログ表示 | E-06 (confirm) | ○ |
| C-08 | 部分一致削除機能 | E-05 (LIKE検索) | ○ |
| C-09 | 入力値30文字制限 | E-05 (left(...,30)) | ○ |
| C-10 | cleanup関数でサニタイズ | E-05 (cleanup) | ○ |
| C-11 | 統計情報をJavaScriptで表示 | E-10 | ○ |
| C-12 | 開始・終了日時表示 | E-10 (startd, endd) | ○ |
| C-13 | 経過時間計算 | E-10 (datediff) | ○ |
| C-14 | ヒット/秒計算 | E-10 (counter/datediff) | ○ |
| C-15 | 横スクロールdiv | E-09 (width:590px;overflow:scroll) | ○ |
| C-16 | ヨーロッパ日時形式 | E-10 (convertEuroDateTime) | ○ |
| C-17 | sortableクラス適用 | E-08 (class="sortable") | ○ |
| C-18 | モニター機能 | E-12 | ○ |
| C-19 | 画面No.144である | E-13 | ○ |
| C-20 | 未認証時リダイレクト | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 1: 中リスク - 全サイトのモニター設定を一括変更する機能があり、誤操作に注意
- 1: 中リスク - ログ全削除機能があり、確認ダイアログはあるが復旧不可能

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、モニター画面にアクセスできることを確認
- [ ] Turn OFF/ONで全サイトのモニター設定が変更されることを確認
- [ ] Remove all logsで確認ダイアログが表示されることを確認
- [ ] 部分一致削除が正しく動作することを確認
- [ ] 統計情報が正しく計算・表示されることを確認
- [ ] show5000=onで表示件数が増加することを確認
