---
generated_at: 2026-01-23 22:28:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：145-ラベル一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_labels.asp` 4-6行目（クラスインスタンス化）
- E-02: `asp/ad_labels.asp` 9行目（件数表示、テーブル表示）
- E-03: `asp/ad_labels.asp` 9-10行目（ループ処理）
- E-04: `asp/ad_labels.asp` 9行目（sortableクラス）
- E-05: `asp/ad_labels.asp` 10行目（アンカー name属性）
- E-06: `asp/includes/label.asp` 2-114行目（cls_labelクラス）
- E-07: `asp/includes/labelList.asp` 2-58行目（cls_labelListクラス）
- E-08: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 184行目
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` 146行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-08 | ○ |
| C-02 | ラベルコードと翻訳値を一覧表示 | E-03 | ○ |
| C-03 | 言語列が動的に生成される | E-03 (for each langKey) | ○ |
| C-04 | 新規ラベル作成リンク | E-02 (ad_label.asp) | ○ |
| C-05 | 編集リンク | E-03 (ad_label.asp?iId=) | ○ |
| C-06 | sortableクラス適用 | E-04 | ○ |
| C-07 | アンカーでラベルIDを設定 | E-05 | ○ |
| C-08 | ラベル件数表示 | E-02 (labelTable.count) | ○ |
| C-09 | 多言語対応機能 | E-09 | ○ |
| C-10 | 画面No.145である | E-10 | ○ |
| C-11 | cls_labelクラス使用 | E-06, E-01 | ○ |
| C-12 | cls_labelListクラス使用 | E-07, E-01 | ○ |
| C-13 | 未認証時リダイレクト | E-08 | ○ |
| C-14 | ラベル0件時テーブル非表示 | E-02 (if labelTable.count>0) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - データ参照のみで更新処理がないため安全
- 0: 低リスク - 認証チェックが適切に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、ラベル一覧画面にアクセスできることを確認
- [ ] 登録されている言語の数に応じて列が動的に表示されることを確認
- [ ] 新規ラベル作成リンクがad_label.aspに遷移することを確認
- [ ] 編集リンクが正しいラベルIDでad_label.aspに遷移することを確認
- [ ] ソート機能が正常に動作することを確認
