---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：146-ラベル編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_label.asp` 10-12行目（クラスインスタンス化、pick）
- E-02: `asp/ad_label.asp` 13-20行目（保存処理）
- E-03: `asp/ad_label.asp` 14行目（checkCSRF）
- E-04: `asp/ad_label.asp` 15-19行目（save、refresh、redirect）
- E-05: `asp/ad_label.asp` 23-26行目（削除処理）
- E-06: `asp/ad_label.asp` 27行目（copyToAll JavaScript）
- E-07: `asp/ad_label.asp` 31行目（confirmダイアログ）
- E-08: `asp/includes/label.asp` 61-96行目（saveメソッド）
- E-09: `asp/includes/label.asp` 82-95行目（DELETE-INSERT方式）
- E-10: `asp/includes/label.asp` 97-106行目（getRequestValues）
- E-11: `asp/includes/label.asp` 105行目（小文字変換、スペース除去）
- E-12: `asp/includes/label.asp` 107-113行目（removeメソッド）
- E-13: `asp/includes/labelList.asp` 30-38行目（refreshメソッド）
- E-14: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-15: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 185行目
- E-16: `docs/code-to-docs/画面一覧/画面一覧.csv` 147行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-14 | ○ |
| C-02 | CSRFトークン検証 | E-03 | ○ |
| C-03 | 保存後にリダイレクト | E-04 | ○ |
| C-04 | 保存後にキャッシュ更新 | E-04, E-13 | ○ |
| C-05 | 削除時に確認ダイアログ | E-07 | ○ |
| C-06 | 削除後にラベル一覧へリダイレクト | E-05 | ○ |
| C-07 | Copy to all機能 | E-06 | ○ |
| C-08 | DELETE-INSERT方式で保存 | E-09 | ○ |
| C-09 | ラベルコード小文字変換 | E-11 (lcase) | ○ |
| C-10 | スペース除去 | E-11 (replace(" ","")) | ○ |
| C-11 | 新規作成時はコード入力可能 | E-01 (isLeeg(label.iId)) | ○ |
| C-12 | 編集時はコード読み取り専用 | E-01 | ○ |
| C-13 | 必須チェックあり | E-08 (check関数) | ○ |
| C-14 | 重複チェックあり | E-08 (check関数内SELECT) | ○ |
| C-15 | 多言語対応機能 | E-15 | ○ |
| C-16 | 画面No.146である | E-16 | ○ |
| C-17 | テキストエリア cols=90 rows=2 | E-06 | ○ |
| C-18 | 未認証時リダイレクト | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - CSRFトークン保護が実装されている
- 1: 中リスク - 削除時の確認ダイアログはあるが、削除後の復旧は不可能

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、ラベル編集画面にアクセスできることを確認
- [ ] 新規ラベルが正常に作成されることを確認
- [ ] 既存ラベルの翻訳値が更新されることを確認
- [ ] Copy to all機能が正常に動作することを確認
- [ ] 削除時に確認ダイアログが表示され、削除が正常に完了することを確認
- [ ] ラベルコード重複時にエラーが表示されることを確認
- [ ] 必須項目未入力時にエラーが表示されることを確認
