---
generated_at: 2026-01-23 22:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：147-IIS管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_iis.asp` 5-18行目（SQL構築）
- E-02: `asp/ad_iis.asp` 6行目（150文字制限、エスケープ）
- E-03: `asp/ad_iis.asp` 20-22行目（IISリロード）
- E-04: `asp/ad_iis.asp` 23行目（確認ダイアログ）
- E-05: `asp/ad_iis.asp` 24-42行目（一覧表示ループ）
- E-06: `asp/ad_iis.asp` 30-32行目（バインディング分解）
- E-07: `asp/ad_iis.asp` 40-42行目（統計情報表示）
- E-08: `asp/ad_iis.asp` 38行目（Modify Bindingsリンク）
- E-09: `asp/iismanager/includes.asp` 10-15行目（getConn関数）
- E-10: `asp/iismanager/includes.asp` 40-121行目（loadIIS関数）
- E-11: `asp/iismanager/includes.asp` 45行目（GetObject IIS接続）
- E-12: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 186行目
- E-14: `docs/code-to-docs/画面一覧/画面一覧.csv` 148行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-12 | ○ |
| C-02 | 検索文字列150文字制限 | E-02 (left(...,150)) | ○ |
| C-03 | シングルクォートエスケープ | E-02 (replace) | ○ |
| C-04 | IISリロード確認ダイアログ | E-04 (confirm) | ○ |
| C-05 | loadIIS()でIIS情報取得 | E-10 | ○ |
| C-06 | GetObjectでIIS接続 | E-11 | ○ |
| C-07 | Accessデータベースにキャッシュ | E-09 (iis.resx) | ○ |
| C-08 | ":80:"でバインディング分解 | E-06 (split) | ○ |
| C-09 | Dictionary で重複排除 | E-06 (dictbindings) | ○ |
| C-10 | サイト数表示 | E-07 (cccc) | ○ |
| C-11 | バインディング数表示 | E-07 (totsize) | ○ |
| C-12 | Modify Bindingsリンク | E-08 | ○ |
| C-13 | servercomment順ソート | E-01 (order by) | ○ |
| C-14 | 複数フィールド検索 | E-01 (OR条件) | ○ |
| C-15 | IIS管理機能 | E-13 | ○ |
| C-16 | 画面No.147である | E-14 | ○ |
| C-17 | on error resume next | E-10 | ○ |
| C-18 | 未認証時リダイレクト | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 2: 高リスク - IISへの直接アクセスを行うため、権限設定とエラーハンドリングに注意
- 1: 中リスク - IISリロードは時間がかかる可能性があり、タイムアウトに注意

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、IIS管理画面にアクセスできることを確認
- [ ] サイト一覧が正しく表示されることを確認
- [ ] 検索機能が正常に動作することを確認
- [ ] Modify Bindingsリンクがバインディング編集画面に遷移することを確認
- [ ] IISリロードが正常に完了することを確認（時間がかかる場合あり）
- [ ] 全バインディング一覧がテキストエリアに表示されることを確認
