---
generated_at: 2026-01-23 22:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：148-バインディング編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_editbindings.asp` 6行目（GetObject IIS接続）
- E-02: `asp/ad_editbindings.asp` 7-8行目（エラーハンドリング）
- E-03: `asp/ad_editbindings.asp` 9-45行目（保存処理）
- E-04: `asp/ad_editbindings.asp` 12行目（改行分割）
- E-05: `asp/ad_editbindings.asp` 14-18行目（Dictionary重複排除）
- E-06: `asp/ad_editbindings.asp` 16行目（小文字変換、http://除去）
- E-07: `asp/ad_editbindings.asp` 27行目（":80:"プレフィックス）
- E-08: `asp/ad_editbindings.asp` 30-31行目（IIS更新）
- E-09: `asp/ad_editbindings.asp` 37-43行目（sites更新）
- E-10: `asp/ad_editbindings.asp` 44行目（成功リダイレクト）
- E-11: `asp/ad_editbindings.asp` 46行目（エラーリダイレクト）
- E-12: `asp/ad_editbindings.asp` 47-49行目（現在値表示）
- E-13: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 187行目
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv` 149行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-13 | ○ |
| C-02 | GetObjectでIIS接続 | E-01 | ○ |
| C-03 | オブジェクト取得失敗時response.end | E-02 | ○ |
| C-04 | 改行区切りで入力 | E-04 (vbcrlf) | ○ |
| C-05 | Dictionaryで重複排除 | E-05 | ○ |
| C-06 | 小文字に変換 | E-06 (lcase) | ○ |
| C-07 | http://を除去 | E-06 (replace) | ○ |
| C-08 | ":80:"プレフィックス付加 | E-07 | ○ |
| C-09 | SetInfo()でIIS反映 | E-08 | ○ |
| C-10 | sitesテーブル更新 | E-09 | ○ |
| C-11 | 成功時fb_saveOKリダイレクト | E-10 | ○ |
| C-12 | 空の場合err_mandatoryエラー | E-11 | ○ |
| C-13 | cols=90 rows=15 | E-12 | ○ |
| C-14 | ポート80固定 | E-07 (":80:") | ○ |
| C-15 | on error resume next | E-01 (4行目) | ○ |
| C-16 | サイト基本設定機能 | E-14 | ○ |
| C-17 | 画面No.148である | E-15 | ○ |
| C-18 | 未認証時リダイレクト | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 2: 高リスク - IISの設定を直接変更するため、誤操作によるサービス停止のリスクあり
- 2: 高リスク - バインディング設定ミスにより、サイトにアクセスできなくなる可能性

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、バインディング編集画面にアクセスできることを確認
- [ ] 現在のバインディングが正しく表示されることを確認
- [ ] バインディングの追加が正常に反映されることを確認
- [ ] バインディングの削除が正常に反映されることを確認
- [ ] 重複したドメインが自動的に排除されることを確認
- [ ] "http://"が自動的に除去されることを確認
- [ ] 空のバインディングでエラーが表示されることを確認
