---
generated_at: 2026-01-23 22:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：149-サイトコピー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/ad_copysite.asp` 5-12行目（初期化処理）
- E-02: `asp/ad_copysite.asp` 8-11行目（初期値クリア）
- E-03: `asp/ad_copysite.asp` 13-39行目（フォーム入力取得）
- E-04: `asp/ad_copysite.asp` 14行目（checkCSRF）
- E-05: `asp/ad_copysite.asp` 35-38行目（check、copy、redirect）
- E-06: `asp/includes/customer.asp` 1312-1420行目（copy()メソッド）
- E-07: `asp/includes/customer.asp` 1316-1320行目（初期化処理）
- E-08: `asp/includes/customer.asp` 1327-1340行目（ページコピー）
- E-09: `asp/includes/customer.asp` 1372-1388行目（copyTable呼び出し）
- E-10: `asp/includes/customer.asp` 1391-1397行目（カタログコピー）
- E-11: `asp/includes/customer.asp` 1403-1413行目（フォームコピー）
- E-12: `asp/includes/customer.asp` 1416-1419行目（メールアドレス更新）
- E-13: `asp/ad_security.asp` 2-3行目（認証チェック）
- E-14: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 188行目
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv` 150行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者専用画面である | E-13 | ○ |
| C-02 | CSRFトークン検証 | E-04 | ○ |
| C-03 | コピー元のsName,sUrl,sAlternateDomainsをクリア | E-02 | ○ |
| C-04 | dOnlineFromをnow()に設定 | E-02 (10行目) | ○ |
| C-05 | check()でバリデーション | E-05 | ○ |
| C-06 | copy()でサイトコピー | E-05, E-06 | ○ |
| C-07 | adminPasswordをデフォルトにリセット | E-07 (1320行目) | ○ |
| C-08 | ページ構造を親子関係維持してコピー | E-08 (Dictionary使用) | ○ |
| C-09 | copyTableで各テーブルをコピー | E-09 | ○ |
| C-10 | カタログをコピー | E-10 | ○ |
| C-11 | フォームをコピー | E-11 | ○ |
| C-12 | メールアドレスを新サイトのwebmasterEmailに更新 | E-12 | ○ |
| C-13 | 成功時にnewAccount=Trueでリダイレクト | E-05 (37行目) | ○ |
| C-14 | doSaveIIS=trueでIISサイト作成 | E-07 (1316行目) | ○ |
| C-15 | デフォルトテンプレートをコピー | E-06 (1324行目) | ○ |
| C-16 | ページ複製機能 | E-14 | ○ |
| C-17 | 画面No.149である | E-15 | ○ |
| C-18 | 未認証時リダイレクト | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 2: 高リスク - 大規模なデータコピーを行うため、処理時間とリソース消費に注意
- 1: 中リスク - IISサイト作成も含まれるため、権限とエラーハンドリングに注意

## 6) レビュアーチェックリスト（最小）

- [ ] 管理者としてログインし、サイトコピー画面にアクセスできることを確認
- [ ] 必須項目（サイト名、URL）のバリデーションが機能することを確認
- [ ] コピーが正常に完了し、新サイトが作成されることを確認
- [ ] ページ構造が親子関係を維持してコピーされることを確認
- [ ] テンプレートが正しくコピーされることを確認
- [ ] メールアドレスが新サイトのwebmasterEmailに更新されることを確認
- [ ] 新サイトの管理者パスワードがデフォルトにリセットされていることを確認
