---
generated_at: 2026-01-23 22:22:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：152-アップグレード3

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **アップグレードステップの連携**：ad_upgrade.aspとの関連性詳細
  2. **QS_IDダミー列の目的**：後処理での削除方法が不明確
  3. **SQL Server型マッピングの妥当性**：一部の型変換（DECIMAL->int等）の意図

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_upgrade3.asp` - メインソースファイル（55行）
- E-02: `asp/ad_upgrade2.asp` - 比較対象（Access形式）
- E-03: `asp/ad_security.asp` - 認証チェックファイル（4行）
- E-04: `asp/begin.asp` - 初期化処理ファイル（204行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はデータベーススキーマをSQL Server形式で出力する | E-01 行38-53: nvarchar, ntext, IDENTITY等のSQL Server型を使用 | ○ |
| C-02 | ADOX.Catalogオブジェクトでメタデータ取得 | E-01 行5-6: `Server.CreateObject("ADOX.Catalog")` | ○ |
| C-03 | "tb"プレフィックスのテーブルのみ処理対象 | E-01 行10: `if lcase(left(table.name,2))="tb"` | ○ |
| C-04 | CREATE TABLE文にQS_IDダミー列を含む | E-01 行11: `CREATE TABLE [" & table.name & "] (QS_ID int NULL)` | ○ |
| C-05 | ALTER TABLE ADD文を生成（COLUMNキーワードなし） | E-01 行15: `ALTER TABLE [" & table.name & "] ADD [" & column.name & "]` | ○ |
| C-06 | 管理者認証が必要 | E-03 行3: `if not convertBool(Session(cId & "isAUTHENTICATEDasADMIN"))` | ○ |
| C-07 | 未認証時はnoaccess.htmにリダイレクト | E-03 行3: `Response.Redirect ("noaccess.htm")` | ○ |
| C-08 | AUTOINCREMENT型はIDENTITY(1,1)に変換 | E-01 行40: `INT IDENTITY(1,1) NOT NULL` | ○ |
| C-09 | VARCHAR型はnvarchar(255)に変換 | E-01 行51: `nvarchar(255)` | ○ |
| C-10 | LONGVARCHAR型はntext NULLに変換 | E-01 行52: `ntext NULL` | ○ |
| C-11 | DECIMAL/DOUBLE/TINYINTは全てintに変換 | E-01 行45-47: 全て`int`を返却 | ○ |
| C-12 | アップグレード処理のステップ3としての位置づけ | **根拠なし** - 画面一覧にはあるが、ad_upgrade.aspとの直接的な連携は未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **ad_upgrade.aspからの遷移パス**：アップグレード処理全体のフローが不明
  - 候補：ad_upgrade.asp / ad_upgrade4.asp のソースコード確認
- **QS_IDダミー列の後処理**：このダミー列の削除手順が不明
- **型変換の意図**：DECIMAL/DOUBLE/TINYINTを全てintに変換する理由

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 認証チェック処理（ソースコードで明確に確認可能）
- **リスク0（低）**: SQL Server基本型マッピング（nvarchar, ntext, datetime等）
- **リスク1（中）**: 一部の型変換（DECIMAL/DOUBLE/TINYINTがintに）の精度低下リスク
- **リスク1（中）**: QS_IDダミー列の後処理手順

## 6) レビュアーチェックリスト（最小）
- [ ] SQL Serverへのデータ型マッピングが適切か確認
- [ ] DECIMAL/DOUBLE/TINYINTをintに変換する理由を確認
- [ ] QS_IDダミー列の後処理（削除）手順を確認
- [ ] アップグレード処理全体のフロー（ステップ1〜4）の関連性を確認
- [ ] ad_upgrade2.asp（Access形式）との差分が正しく説明されているか確認
