---
generated_at: 2026-01-23 22:24:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：153-アップグレード4

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **アップグレードステップの連携**：ad_upgrade.aspとの関連性詳細
  2. **ad_upgrade3.aspとの差分**：型マッピングが同一であることの確認
  3. **利用シーン**：SQL Server Management Studio等での実行を想定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_upgrade4.asp` - メインソースファイル（55行）
- E-02: `asp/ad_upgrade3.asp` - 比較対象（db.execute形式）
- E-03: `asp/ad_upgrade2.asp` - 比較対象（Access形式）
- E-04: `asp/ad_security.asp` - 認証チェックファイル（4行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は純粋SQL形式（db.executeラッパーなし）で出力する | E-01 行11,15: `Response.Write "CREATE TABLE..."` `Response.Write "ALTER TABLE..."` | ○ |
| C-02 | SQL文はセミコロン終端 | E-01 行11,15: 各SQL文の末尾に`;`を含む | ○ |
| C-03 | ADOX.Catalogオブジェクトでメタデータ取得 | E-01 行5-6: `Server.CreateObject("ADOX.Catalog")` | ○ |
| C-04 | "tb"プレフィックスのテーブルのみ処理対象 | E-01 行10: `if lcase(left(table.name,2))="tb"` | ○ |
| C-05 | CREATE TABLE文にQS_IDダミー列を含む | E-01 行11: `CREATE TABLE [" & table.name & "] (QS_ID int NULL);` | ○ |
| C-06 | 管理者認証が必要 | E-04 行3: `if not convertBool(Session(cId & "isAUTHENTICATEDasADMIN"))` | ○ |
| C-07 | GetSQLTypeName関数はad_upgrade3.aspと同一 | E-01 行38-53, E-02 行38-53: 同一のデータ型マッピング | ○ |
| C-08 | SQL Server互換の型を使用 | E-01 行40-52: nvarchar, ntext, IDENTITY等 | ○ |
| C-09 | 未認証時はnoaccess.htmにリダイレクト | E-04 行3: `Response.Redirect ("noaccess.htm")` | ○ |
| C-10 | SQL Server Management Studio等で直接実行可能 | E-01: SQL構文とセミコロン終端から推測可能 | ○ |
| C-11 | アップグレード処理のステップ4としての位置づけ | **根拠なし** - 画面一覧にはあるが、ad_upgrade.aspとの直接的な連携は未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **ad_upgrade.aspからの遷移パス**：アップグレード処理全体のフローが不明
  - 候補：ad_upgrade.asp のソースコード確認
- **各ステップ（2,3,4）の使い分け**：どのような状況でどのステップを使用すべきか

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 認証チェック処理（ソースコードで明確に確認可能）
- **リスク0（低）**: SQL文の出力形式（セミコロン終端が確認可能）
- **リスク0（低）**: 型マッピング（ad_upgrade3.aspと同一）
- **リスク1（中）**: アップグレードフロー全体の連携（他のアップグレード画面との関係）

## 6) レビュアーチェックリスト（最小）
- [ ] 出力されるSQL文が実際にセミコロン終端であるか確認
- [ ] ad_upgrade3.aspとの差分が出力形式のみであることを確認
- [ ] GetSQLTypeName関数が完全に同一であることを確認
- [ ] アップグレード処理全体のフロー（ステップ1〜4）の関連性を確認
- [ ] SQL Server Management Studioでの動作確認（可能であれば）
