---
generated_at: 2026-01-23 22:26:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：154-アプリケーションリセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **removeApplication関数の実装**：キャッシュクリアの具体的な処理内容
  2. **セキュリティ考慮**：SHA256認証トークンの安全性
  3. **HTTPタイムアウト設定**：大量サイト処理時のタイムアウト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_resetAllAPP.asp` - メインソースファイル（37行）
- E-02: `asp/ad_resetAPP.asp` - 個別リセット処理ファイル（9行）
- E-03: `asp/ad_security.asp` - 認証チェックファイル（4行）
- E-04: `asp/includes/customerList.asp` - 顧客リストクラス（41行）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全顧客サイトに対してリセットを実行する | E-01 行9-18: FOR EACHで全顧客をループ | ○ |
| C-02 | cls_customerListクラスで顧客リストを取得 | E-01 行5-7: `new cls_customerList` と `customerList.table` | ○ |
| C-03 | HTTPリクエストでad_resetAPP.aspを呼び出す | E-01 行10: `urlApp=customers(c).sQSUrl & "/asp/ad_resetAPP.asp..."` | ○ |
| C-04 | SHA256認証トークンを使用 | E-01 行10: `sha256(C_ADMINPASSWORD)` | ○ |
| C-05 | MSXML2.ServerXMLHTTPでリクエスト送信 | E-01 行23: `CreateObject("MSXML2.ServerXMLHTTP")` | ○ |
| C-06 | レスポンスに"Application Reset"含まれれば成功 | E-01 行31: `if instr(oXMLHTTP.responseStream,"Application Reset")>0` | ○ |
| C-07 | 成功時は"Reset OK"を表示 | E-01 行12: `Response.Write customers(c).sUrl & " Reset OK"` | ○ |
| C-08 | 失敗時は"Reset NOT OK"を赤字太字で表示 | E-01 行14: `<font color=Red><b>Reset NOT OK</b></font>` | ○ |
| C-09 | Response.Flushで即時出力 | E-01 行17: `Response.Flush` | ○ |
| C-10 | ad_resetAPP.aspでremoveApplication()を呼び出す | E-02 行4: `removeApplication()` | ○ |
| C-11 | ad_resetAPP.aspで"Application Reset"を出力 | E-02 行5: `Response.Write "Application Reset"` | ○ |
| C-12 | 管理者認証が必要 | E-03 行3: `if not convertBool(Session(cId & "isAUTHENTICATEDasADMIN"))` | ○ |
| C-13 | エラー発生時も処理継続 | E-01 行20,26-29: `on error resume next` とerr.clearで継続 | ○ |
| C-14 | removeApplication関数の具体的なキャッシュクリア処理 | **根拠なし** - 関数の実装は別ファイル（未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **removeApplication関数の実装**：具体的に何をクリアしているかの詳細
  - 候補：includes/functions.asp または別のインクルードファイル
- **大量サイト処理時の性能**：同期処理のため時間がかかる可能性

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 認証チェック処理（ソースコードで明確に確認可能）
- **リスク0（低）**: HTTPリクエスト処理（MSXML2.ServerXMLHTTPの標準的な使用）
- **リスク1（中）**: SHA256認証トークンのセキュリティ（URLパラメータでの送信）
- **リスク1（中）**: 大量サイト処理時のタイムアウトリスク

## 6) レビュアーチェックリスト（最小）
- [ ] removeApplication関数の実装を確認し、何がクリアされるか把握する
- [ ] SHA256認証トークンの安全性を確認
- [ ] 大量サイト処理時のタイムアウト設定を確認
- [ ] HTTPエラー時のリカバリー処理が適切か確認
- [ ] Response.Flushの使用が適切か確認（バッファリング設定との整合性）
