---
generated_at: 2026-01-23 22:28:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：155-アプリケーションリセット（個別）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **removeApplication関数の実装詳細**：具体的なキャッシュクリア処理
  2. **apwパラメータの認証処理**：ad_security.aspでの検証ロジック
  3. **セキュリティ考慮**：URL経由での認証トークン送信の安全性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_resetAPP.asp` - メインソースファイル（9行）
- E-02: `asp/ad_security.asp` - 認証チェックファイル（4行）
- E-03: `asp/ad_resetAllAPP.asp` - 一括リセット処理（呼び出し元）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | removeApplication()関数でキャッシュクリア | E-01 行4: `removeApplication()` | ○ |
| C-02 | "Application Reset"メッセージを出力 | E-01 行5: `Response.Write "Application Reset"` | ○ |
| C-03 | サイトリンクを出力 | E-01 行6: `Response.Write "<br /><a href='"&customer.surl&"'>Check site</a>"` | ○ |
| C-04 | logon.logoffでセッション終了 | E-01 行7: `logon.logoff` | ○ |
| C-05 | Response.Endで処理終了 | E-01 行8: `Response.End` | ○ |
| C-06 | ad_security.aspで認証チェック | E-01 行4: `<!-- #include file="ad_security.asp"-->` | ○ |
| C-07 | 管理者認証が必要 | E-02 行3: `Session(cId & "isAUTHENTICATEDasADMIN")` チェック | ○ |
| C-08 | 一括リセット処理から呼び出される | E-03 行10: 呼び出しURL構築 | ○ |
| C-09 | apwパラメータでSHA256認証トークンを受け取る | E-03 行10: `apw=sha256(C_ADMINPASSWORD)` | ○ |
| C-10 | removeApplication関数の具体的な実装 | **根拠なし** - 関数の実装は別ファイル（未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **removeApplication関数の実装**：具体的に何をクリアしているかの詳細
  - 候補：includes/functions.asp または別のインクルードファイル
- **apwパラメータの検証ロジック**：ad_security.aspでの処理詳細

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 出力メッセージ（ソースコードで明確に確認可能）
- **リスク0（低）**: セッション終了処理（logon.logoff呼び出し）
- **リスク1（中）**: removeApplication関数の実装詳細
- **リスク1（中）**: URLパラメータでの認証トークン送信のセキュリティ

## 6) レビュアーチェックリスト（最小）
- [ ] removeApplication関数の実装を確認し、何がクリアされるか把握する
- [ ] ad_security.aspでのapwパラメータ検証ロジックを確認
- [ ] URL経由での認証トークン送信のセキュリティリスクを評価
- [ ] customer.surlが正しく取得されることを確認
- [ ] logon.logoff後の再認証フローを確認
