---
generated_at: 2026-01-23 22:30:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：156-管理メニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_adminMenu.asp` - メインソースファイル（6行）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Customersリンクがad_clientList.aspへ遷移 | E-01 行2: `getArtLink("ad_clientList.asp","Customers"...)` | ○ |
| C-02 | New Customerリンクがad_client.aspへ遷移 | E-01 行3: `getArtLink("ad_client.asp","New Customer"...)` | ○ |
| C-03 | Products/Servicesリンクがad_clientproducts.aspへ遷移 | E-01 行4: `getArtLink("ad_clientproducts.asp","Products/Services"...)` | ○ |
| C-04 | Add Product/Serviceリンクがad_clientproduct.aspへ遷移 | E-01 行5: `getArtLink("ad_clientproduct.asp","Add Product/Service"...)` | ○ |
| C-05 | 中央揃えで表示 | E-01 行2: `<p align="center">` | ○ |
| C-06 | getArtLink関数でリンク生成 | E-01 行2-5: 全リンクがgetArtLink関数を使用 | ○ |
| C-07 | リンク間は非改行スペースで区切り | E-01 行2-5: `&nbsp;&nbsp;` | ○ |
| C-08 | 本画面は認証チェックを行わない | E-01: ad_security.aspのインクルードなし | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（本画面は非常にシンプルで、全ての主張に根拠がある）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全てのリンク先（ソースコードで明確に確認可能）
- **リスク0（低）**: レイアウト（HTMLで明確）

## 6) レビュアーチェックリスト（最小）
- [ ] リンク先のファイルが全て存在することを確認
- [ ] getArtLink関数の実装を確認（必要に応じて）
- [ ] インクルード元での認証チェックが適切に行われていることを確認
