---
generated_at: 2026-01-23 22:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：158-トップページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **execBeforePageLoadの実装詳細**：カスタム前処理の詳細
  2. **テンプレートエンジンの動作**：buildTemplateメソッドの詳細
  3. **全pageActionの網羅性**：process.aspの全分岐の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `default.asp` - メインソースファイル（3行）
- E-02: `asp/begin.asp` - 初期化処理ファイル（204行）
- E-03: `asp/process.asp` - メインロジックファイル（290行）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | default.aspがエントリーポイント | E-01: 3行のシンプルな構造 | ○ |
| C-02 | begin.aspをインクルード | E-01 行1: `<!-- #include file="asp/begin.asp"-->` | ○ |
| C-03 | execBeforePageLoadを実行 | E-01 行2: `<%=run(execBeforePageLoad)%>` | ○ |
| C-04 | process.aspをインクルード | E-01 行3: `<!-- #include file="asp/process.asp"-->` | ○ |
| C-05 | ユーザーフレンドリーURLをサポート | E-03 行10-12: `pickByUserFriendlyURL()` | ○ |
| C-06 | pageAction分岐処理 | E-03 行40-167: Select Case文 | ○ |
| C-07 | loginアクション対応 | E-03 行133: `case lcase(clogin)` | ○ |
| C-08 | searchアクション対応 | E-03 行50: `case "search"` | ○ |
| C-09 | sitemapアクション対応 | E-03 行50: `case "sitemap"` | ○ |
| C-10 | voteアクション対応 | E-03 行61-81: `case "vote"` | ○ |
| C-11 | showitemアクション対応 | E-03 行50: `case "showitem"` | ○ |
| C-12 | パスワード保護ページの認証チェック | E-03 行219: `logon.logonItem` | ○ |
| C-13 | イントラネットページの認証チェック | E-03 行220-231: `bIntranet` と `authenticatedIntranet` | ○ |
| C-14 | オフラインページの制御 | E-03 行189-205: `bOnline` チェック | ○ |
| C-15 | 訪問ログ記録 | E-03 行268-269: `AddHit()` と `addVisit()` | ○ |
| C-16 | テンプレートビルド | E-03 行279: `buildTemplate()` | ○ |
| C-17 | 404エラーページ処理 | E-03 行23-32: `b404` チェック | ○ |
| C-18 | execBeforePageLoadの具体的な動作 | **根拠なし** - run関数の実装詳細は別ファイル | △ |

## 4) 不足情報（Unknown / Missing）
- **execBeforePageLoad変数の初期化場所**：どこで設定されるかの確認
  - 候補：includes/functions.asp または web_config.asp
- **buildTemplateメソッドの詳細**：テンプレートレンダリングの詳細
  - 候補：includes/page.asp または includes/template.asp

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: エントリーポイントの構造（ソースコードで明確）
- **リスク0（低）**: pageAction分岐（process.aspで明確）
- **リスク1（中）**: テンプレートエンジンの動作詳細
- **リスク1（中）**: 全てのpageActionの網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] process.aspの全pageActionが設計書に記載されているか確認
- [ ] テンプレートビルド処理の詳細を確認
- [ ] execBeforePageLoad変数の設定箇所を確認
- [ ] 認証チェックのフローが正しいか確認
- [ ] 404エラーページの表示条件を確認
