---
generated_at: 2026-01-23 22:36:00
metrics:
  claims_total: 6
  claims_with_evidence: 6
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：159-インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：6 / 6、根拠なし：0
- 優先レビュー（高）
  1. なし（全項目が根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `index.asp` - メインソースファイル（1行）
- E-02: `default.asp` - インクルード先ファイル
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | default.aspをインクルード | E-01: `<!-- #include file="default.asp"-->` | ○ |
| C-02 | ファイル内容は1行のみ | E-01: 1行のみ | ○ |
| C-03 | default.aspと同一の処理を実行 | E-01, E-02: インクルードにより処理委譲 | ○ |
| C-04 | IIS既定ドキュメントへの対応 | E-01: index.aspの存在理由として合理的 | ○ |
| C-05 | ラッパーファイルとして機能 | E-01: インクルードのみで独自処理なし | ○ |
| C-06 | 権限制御はdefault.aspに委譲 | E-01: 独自の認証チェックなし | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（本画面は非常にシンプルで、全ての主張に根拠がある）

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: 全ての主張（ソースコードで明確に確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] ファイルが本当に1行のみであることを確認
- [ ] default.aspへのインクルードが正しく動作することを確認
- [ ] SEO的な重複コンテンツ対策（カノニカルURL）の状況を確認
